/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811;

import java.util.Objects;
import org.opendaylight.controller.config.api.DependencyResolver;
import org.opendaylight.controller.config.api.JmxAttribute;
import org.opendaylight.controller.config.api.ModuleIdentifier;
import org.opendaylight.controller.config.api.annotations.Description;
import org.opendaylight.controller.config.spi.AbstractModule;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.config.rev150811.TransportProtocol;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811.RadioHeadConnectionProviderModuleMXBean;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811.Threads;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811.Tls;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.rev150811.RadioHeadConnectionProviderServiceInterface;
import org.opendaylight.yangtools.yang.binding.annotations.ModuleQName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ModuleQName(namespace="urn:opendaylight:params:xml:ns:yang:ocp:radiohead:connection:provider:impl", name="ocp-radiohead-connection-provider-impl", revision="2015-08-11")
public abstract class AbstractRadioHeadConnectionProviderModule
extends AbstractModule<AbstractRadioHeadConnectionProviderModule>
implements RadioHeadConnectionProviderModuleMXBean,
RadioHeadConnectionProviderServiceInterface {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractRadioHeadConnectionProviderModule.class);
    public static final JmxAttribute addressJmxAttribute = new JmxAttribute("Address");
    private IpAddress address;
    public static final JmxAttribute transportProtocolJmxAttribute = new JmxAttribute("TransportProtocol");
    private TransportProtocol transportProtocol;
    public static final JmxAttribute portJmxAttribute = new JmxAttribute("Port");
    private Integer port;
    public static final JmxAttribute threadsJmxAttribute = new JmxAttribute("Threads");
    private Threads threads;
    public static final JmxAttribute radioHeadIdleTimeoutJmxAttribute = new JmxAttribute("RadioHeadIdleTimeout");
    private Long radioHeadIdleTimeout;
    public static final JmxAttribute tlsJmxAttribute = new JmxAttribute("Tls");
    private Tls tls;

    public AbstractRadioHeadConnectionProviderModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver) {
        super(identifier, dependencyResolver);
    }

    public AbstractRadioHeadConnectionProviderModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver, AbstractRadioHeadConnectionProviderModule oldModule, AutoCloseable oldInstance) {
        super(identifier, dependencyResolver, (AbstractModule)oldModule, oldInstance);
    }

    public void validate() {
        this.customValidation();
    }

    protected void customValidation() {
    }

    protected final void resolveDependencies() {
        if (this.threads != null) {
            this.threads.injectDependencyResolver(this.dependencyResolver);
        }
        if (this.tls != null) {
            this.tls.injectDependencyResolver(this.dependencyResolver);
        }
    }

    public boolean canReuseInstance(AbstractRadioHeadConnectionProviderModule oldModule) {
        return this.isSame(oldModule);
    }

    public AutoCloseable reuseInstance(AutoCloseable oldInstance) {
        return oldInstance;
    }

    public boolean isSame(AbstractRadioHeadConnectionProviderModule other) {
        if (other == null) {
            throw new IllegalArgumentException("Parameter 'other' is null");
        }
        if (!Objects.deepEquals(this.address, other.address)) {
            return false;
        }
        if (!Objects.deepEquals(this.transportProtocol, other.transportProtocol)) {
            return false;
        }
        if (!Objects.deepEquals(this.port, other.port)) {
            return false;
        }
        if (!Objects.deepEquals(this.threads, other.threads)) {
            return false;
        }
        if (!Objects.deepEquals(this.radioHeadIdleTimeout, other.radioHeadIdleTimeout)) {
            return false;
        }
        return Objects.deepEquals(this.tls, other.tls);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractRadioHeadConnectionProviderModule that = (AbstractRadioHeadConnectionProviderModule)o;
        return this.identifier.equals((Object)that.identifier);
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }

    @Override
    public IpAddress getAddress() {
        return this.address;
    }

    @Override
    @Description(value="address of local listening interface")
    public void setAddress(IpAddress address) {
        this.address = address;
    }

    @Override
    public TransportProtocol getTransportProtocol() {
        return this.transportProtocol;
    }

    @Override
    @Description(value="Transport protocol used for communication.")
    public void setTransportProtocol(TransportProtocol transportProtocol) {
        this.transportProtocol = transportProtocol;
    }

    @Override
    public Integer getPort() {
        return this.port;
    }

    @Override
    @Description(value="local listening port")
    public void setPort(Integer port) {
        this.port = port;
    }

    @Override
    public Threads getThreads() {
        return this.threads;
    }

    @Override
    public void setThreads(Threads threads) {
        this.threads = threads;
    }

    @Override
    public Long getRadioHeadIdleTimeout() {
        return this.radioHeadIdleTimeout;
    }

    @Override
    @Description(value="idle timeout in [ms]")
    public void setRadioHeadIdleTimeout(Long radioHeadIdleTimeout) {
        this.radioHeadIdleTimeout = radioHeadIdleTimeout;
    }

    @Override
    public Tls getTls() {
        return this.tls;
    }

    @Override
    public void setTls(Tls tls) {
        this.tls = tls;
    }

    public Logger getLogger() {
        return LOG;
    }
}

