/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811.modules.module.configuration;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.config.rev150811.TransportProtocol;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811.modules.module.configuration.OcpRadioheadConnectionProviderImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811.modules.module.configuration.ocp.radiohead.connection.provider.impl.Threads;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811.modules.module.configuration.ocp.radiohead.connection.provider.impl.Tls;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class OcpRadioheadConnectionProviderImplBuilder
implements Builder<OcpRadioheadConnectionProviderImpl> {
    private IpAddress _address;
    private Integer _port;
    private Long _radioHeadIdleTimeout;
    private Threads _threads;
    private Tls _tls;
    private TransportProtocol _transportProtocol;
    Map<Class<? extends Augmentation<OcpRadioheadConnectionProviderImpl>>, Augmentation<OcpRadioheadConnectionProviderImpl>> augmentation = Collections.emptyMap();

    public OcpRadioheadConnectionProviderImplBuilder() {
    }

    public OcpRadioheadConnectionProviderImplBuilder(OcpRadioheadConnectionProviderImpl base) {
        AugmentationHolder casted;
        this._address = base.getAddress();
        this._port = base.getPort();
        this._radioHeadIdleTimeout = base.getRadioHeadIdleTimeout();
        this._threads = base.getThreads();
        this._tls = base.getTls();
        this._transportProtocol = base.getTransportProtocol();
        if (base instanceof OcpRadioheadConnectionProviderImplImpl) {
            OcpRadioheadConnectionProviderImplImpl impl = (OcpRadioheadConnectionProviderImplImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<OcpRadioheadConnectionProviderImpl>>, Augmentation<OcpRadioheadConnectionProviderImpl>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<OcpRadioheadConnectionProviderImpl>>, Augmentation<OcpRadioheadConnectionProviderImpl>>(casted.augmentations());
        }
    }

    public IpAddress getAddress() {
        return this._address;
    }

    public Integer getPort() {
        return this._port;
    }

    public Long getRadioHeadIdleTimeout() {
        return this._radioHeadIdleTimeout;
    }

    public Threads getThreads() {
        return this._threads;
    }

    public Tls getTls() {
        return this._tls;
    }

    public TransportProtocol getTransportProtocol() {
        return this._transportProtocol;
    }

    public <E extends Augmentation<OcpRadioheadConnectionProviderImpl>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public OcpRadioheadConnectionProviderImplBuilder setAddress(IpAddress value) {
        this._address = value;
        return this;
    }

    private static void checkPortRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public OcpRadioheadConnectionProviderImplBuilder setPort(Integer value) {
        if (value != null) {
            OcpRadioheadConnectionProviderImplBuilder.checkPortRange(value);
        }
        this._port = value;
        return this;
    }

    private static void checkRadioHeadIdleTimeoutRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public OcpRadioheadConnectionProviderImplBuilder setRadioHeadIdleTimeout(Long value) {
        if (value != null) {
            OcpRadioheadConnectionProviderImplBuilder.checkRadioHeadIdleTimeoutRange(value);
        }
        this._radioHeadIdleTimeout = value;
        return this;
    }

    public OcpRadioheadConnectionProviderImplBuilder setThreads(Threads value) {
        this._threads = value;
        return this;
    }

    public OcpRadioheadConnectionProviderImplBuilder setTls(Tls value) {
        this._tls = value;
        return this;
    }

    public OcpRadioheadConnectionProviderImplBuilder setTransportProtocol(TransportProtocol value) {
        this._transportProtocol = value;
        return this;
    }

    public OcpRadioheadConnectionProviderImplBuilder addAugmentation(Class<? extends Augmentation<OcpRadioheadConnectionProviderImpl>> augmentationType, Augmentation<OcpRadioheadConnectionProviderImpl> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<OcpRadioheadConnectionProviderImpl>>, Augmentation<OcpRadioheadConnectionProviderImpl>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public OcpRadioheadConnectionProviderImplBuilder removeAugmentation(Class<? extends Augmentation<OcpRadioheadConnectionProviderImpl>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public OcpRadioheadConnectionProviderImpl build() {
        return new OcpRadioheadConnectionProviderImplImpl(this);
    }

    private static final class OcpRadioheadConnectionProviderImplImpl
    implements OcpRadioheadConnectionProviderImpl {
        private final IpAddress _address;
        private final Integer _port;
        private final Long _radioHeadIdleTimeout;
        private final Threads _threads;
        private final Tls _tls;
        private final TransportProtocol _transportProtocol;
        private Map<Class<? extends Augmentation<OcpRadioheadConnectionProviderImpl>>, Augmentation<OcpRadioheadConnectionProviderImpl>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<OcpRadioheadConnectionProviderImpl> getImplementedInterface() {
            return OcpRadioheadConnectionProviderImpl.class;
        }

        private OcpRadioheadConnectionProviderImplImpl(OcpRadioheadConnectionProviderImplBuilder base) {
            this._address = base.getAddress();
            this._port = base.getPort();
            this._radioHeadIdleTimeout = base.getRadioHeadIdleTimeout();
            this._threads = base.getThreads();
            this._tls = base.getTls();
            this._transportProtocol = base.getTransportProtocol();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<OcpRadioheadConnectionProviderImpl>>, Augmentation<OcpRadioheadConnectionProviderImpl>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<OcpRadioheadConnectionProviderImpl>>, Augmentation<OcpRadioheadConnectionProviderImpl>>(base.augmentation);
                }
            }
        }

        @Override
        public IpAddress getAddress() {
            return this._address;
        }

        @Override
        public Integer getPort() {
            return this._port;
        }

        @Override
        public Long getRadioHeadIdleTimeout() {
            return this._radioHeadIdleTimeout;
        }

        @Override
        public Threads getThreads() {
            return this._threads;
        }

        @Override
        public Tls getTls() {
            return this._tls;
        }

        @Override
        public TransportProtocol getTransportProtocol() {
            return this._transportProtocol;
        }

        public <E extends Augmentation<OcpRadioheadConnectionProviderImpl>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._address);
            result = 31 * result + Objects.hashCode(this._port);
            result = 31 * result + Objects.hashCode(this._radioHeadIdleTimeout);
            result = 31 * result + Objects.hashCode(this._threads);
            result = 31 * result + Objects.hashCode(this._tls);
            result = 31 * result + Objects.hashCode(this._transportProtocol);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!OcpRadioheadConnectionProviderImpl.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            OcpRadioheadConnectionProviderImpl other = (OcpRadioheadConnectionProviderImpl)obj;
            if (!Objects.equals(this._address, other.getAddress())) {
                return false;
            }
            if (!Objects.equals(this._port, other.getPort())) {
                return false;
            }
            if (!Objects.equals(this._radioHeadIdleTimeout, other.getRadioHeadIdleTimeout())) {
                return false;
            }
            if (!Objects.equals(this._threads, other.getThreads())) {
                return false;
            }
            if (!Objects.equals(this._tls, other.getTls())) {
                return false;
            }
            if (!Objects.equals(this._transportProtocol, other.getTransportProtocol())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                OcpRadioheadConnectionProviderImplImpl otherImpl = (OcpRadioheadConnectionProviderImplImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<OcpRadioheadConnectionProviderImpl>>, Augmentation<OcpRadioheadConnectionProviderImpl>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "OcpRadioheadConnectionProviderImpl [";
            StringBuilder builder = new StringBuilder(name);
            if (this._address != null) {
                builder.append("_address=");
                builder.append(this._address);
                builder.append(", ");
            }
            if (this._port != null) {
                builder.append("_port=");
                builder.append(this._port);
                builder.append(", ");
            }
            if (this._radioHeadIdleTimeout != null) {
                builder.append("_radioHeadIdleTimeout=");
                builder.append(this._radioHeadIdleTimeout);
                builder.append(", ");
            }
            if (this._threads != null) {
                builder.append("_threads=");
                builder.append(this._threads);
                builder.append(", ");
            }
            if (this._tls != null) {
                builder.append("_tls=");
                builder.append(this._tls);
                builder.append(", ");
            }
            if (this._transportProtocol != null) {
                builder.append("_transportProtocol=");
                builder.append(this._transportProtocol);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

