/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811.modules.module.configuration.ocp.statistics.collection.service.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ocp.radiohead.connection.provider.impl.rev150811.modules.module.configuration.ocp.statistics.collection.service.impl.OcpStatistics;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class OcpStatisticsBuilder
implements Builder<OcpStatistics> {
    private Integer _logReportDelay;
    private Boolean _ocpStatisticsCollect;
    Map<Class<? extends Augmentation<OcpStatistics>>, Augmentation<OcpStatistics>> augmentation = Collections.emptyMap();

    public OcpStatisticsBuilder() {
    }

    public OcpStatisticsBuilder(OcpStatistics base) {
        AugmentationHolder casted;
        this._logReportDelay = base.getLogReportDelay();
        this._ocpStatisticsCollect = base.isOcpStatisticsCollect();
        if (base instanceof OcpStatisticsImpl) {
            OcpStatisticsImpl impl = (OcpStatisticsImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<OcpStatistics>>, Augmentation<OcpStatistics>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<OcpStatistics>>, Augmentation<OcpStatistics>>(casted.augmentations());
        }
    }

    public Integer getLogReportDelay() {
        return this._logReportDelay;
    }

    public Boolean isOcpStatisticsCollect() {
        return this._ocpStatisticsCollect;
    }

    public <E extends Augmentation<OcpStatistics>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkLogReportDelayRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public OcpStatisticsBuilder setLogReportDelay(Integer value) {
        if (value != null) {
            OcpStatisticsBuilder.checkLogReportDelayRange(value);
        }
        this._logReportDelay = value;
        return this;
    }

    public OcpStatisticsBuilder setOcpStatisticsCollect(Boolean value) {
        this._ocpStatisticsCollect = value;
        return this;
    }

    public OcpStatisticsBuilder addAugmentation(Class<? extends Augmentation<OcpStatistics>> augmentationType, Augmentation<OcpStatistics> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<OcpStatistics>>, Augmentation<OcpStatistics>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public OcpStatisticsBuilder removeAugmentation(Class<? extends Augmentation<OcpStatistics>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public OcpStatistics build() {
        return new OcpStatisticsImpl(this);
    }

    private static final class OcpStatisticsImpl
    implements OcpStatistics {
        private final Integer _logReportDelay;
        private final Boolean _ocpStatisticsCollect;
        private Map<Class<? extends Augmentation<OcpStatistics>>, Augmentation<OcpStatistics>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<OcpStatistics> getImplementedInterface() {
            return OcpStatistics.class;
        }

        private OcpStatisticsImpl(OcpStatisticsBuilder base) {
            this._logReportDelay = base.getLogReportDelay();
            this._ocpStatisticsCollect = base.isOcpStatisticsCollect();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<OcpStatistics>>, Augmentation<OcpStatistics>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<OcpStatistics>>, Augmentation<OcpStatistics>>(base.augmentation);
                }
            }
        }

        @Override
        public Integer getLogReportDelay() {
            return this._logReportDelay;
        }

        @Override
        public Boolean isOcpStatisticsCollect() {
            return this._ocpStatisticsCollect;
        }

        public <E extends Augmentation<OcpStatistics>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._logReportDelay);
            result = 31 * result + Objects.hashCode(this._ocpStatisticsCollect);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!OcpStatistics.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            OcpStatistics other = (OcpStatistics)obj;
            if (!Objects.equals(this._logReportDelay, other.getLogReportDelay())) {
                return false;
            }
            if (!Objects.equals(this._ocpStatisticsCollect, other.isOcpStatisticsCollect())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                OcpStatisticsImpl otherImpl = (OcpStatisticsImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<OcpStatistics>>, Augmentation<OcpStatistics>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "OcpStatistics [";
            StringBuilder builder = new StringBuilder(name);
            if (this._logReportDelay != null) {
                builder.append("_logReportDelay=");
                builder.append(this._logReportDelay);
                builder.append(", ");
            }
            if (this._ocpStatisticsCollect != null) {
                builder.append("_ocpStatisticsCollect=");
                builder.append(this._ocpStatisticsCollect);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

