/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.ocpjava.protocol.impl.clients;

import java.security.KeyStore;
import java.security.Security;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.opendaylight.ocpjava.protocol.impl.clients.ClientSslKeyStore;
import org.opendaylight.ocpjava.protocol.impl.clients.ClientSslTrustStore;

public final class ClientSslContextFactory {
    private static final String PROTOCOL = "TLS";
    private static final SSLContext CLIENT_CONTEXT;

    private ClientSslContextFactory() {
        throw new UnsupportedOperationException("Utility class shouldn't be instantiated");
    }

    public static SSLContext getClientContext() {
        return CLIENT_CONTEXT;
    }

    static {
        SSLContext clientContext;
        String algorithm = Security.getProperty("ssl.KeyManagerFactory.algorithm");
        if (algorithm == null) {
            algorithm = "SunX509";
        }
        try {
            KeyStore ks = KeyStore.getInstance("JKS");
            ks.load(ClientSslKeyStore.asInputStream(), ClientSslKeyStore.getKeyStorePassword());
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(algorithm);
            kmf.init(ks, ClientSslKeyStore.getCertificatePassword());
            KeyStore ts = KeyStore.getInstance("JKS");
            ts.load(ClientSslTrustStore.asInputStream(), ClientSslTrustStore.getKeyStorePassword());
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(algorithm);
            tmf.init(ts);
            clientContext = SSLContext.getInstance(PROTOCOL);
            clientContext.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
        }
        catch (Exception e) {
            throw new Error("Failed to initialize the client-side SSLContext", e);
        }
        CLIENT_CONTEXT = clientContext;
    }
}

