/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.ocpjava.protocol.impl.clients;

import io.netty.channel.ChannelHandlerContext;
import java.util.Deque;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.opendaylight.ocpjava.protocol.impl.clients.ClientEvent;
import org.opendaylight.ocpjava.protocol.impl.clients.SendEvent;
import org.opendaylight.ocpjava.protocol.impl.clients.WaitForMessageEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScenarioHandler
extends Thread {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScenarioHandler.class);
    private Deque<ClientEvent> scenario;
    private BlockingQueue<byte[]> ocpMsg;
    private ChannelHandlerContext ctx;
    private int eventNumber;
    private boolean scenarioFinished = false;

    public ScenarioHandler(Deque<ClientEvent> scenario) {
        this.scenario = scenario;
        this.ocpMsg = new LinkedBlockingQueue<byte[]>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int freezeCounter = 0;
        while (!this.scenario.isEmpty()) {
            ClientEvent peek;
            block13: {
                ClientEvent event;
                LOGGER.debug("Running event #{}", (Object)this.eventNumber);
                peek = this.scenario.peekLast();
                if (peek instanceof WaitForMessageEvent) {
                    LOGGER.debug("WaitForMessageEvent");
                    try {
                        event = (WaitForMessageEvent)peek;
                        ((WaitForMessageEvent)event).setHeaderReceived(this.ocpMsg.poll(2000L, TimeUnit.MILLISECONDS));
                        break block13;
                    }
                    catch (Exception e) {
                        LOGGER.error(e.getMessage(), (Throwable)e);
                        break;
                    }
                }
                if (peek instanceof SendEvent) {
                    LOGGER.debug("Proceed - sendevent");
                    event = (SendEvent)peek;
                    ((SendEvent)event).setCtx(this.ctx);
                }
            }
            if (peek.eventExecuted()) {
                this.scenario.removeLast();
                ++this.eventNumber;
                freezeCounter = 0;
            } else {
                ++freezeCounter;
            }
            if (freezeCounter > 2) {
                LOGGER.warn("Scenario frozen: {}", (Object)freezeCounter);
                break;
            }
            try {
                ScenarioHandler.sleep(100L);
            }
            catch (InterruptedException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        LOGGER.debug("Scenario finished");
        ScenarioHandler scenarioHandler = this;
        synchronized (scenarioHandler) {
            this.scenarioFinished = true;
            this.notify();
        }
    }

    public boolean isEmpty() {
        return this.scenario.isEmpty();
    }

    public Deque<ClientEvent> getScenario() {
        return this.scenario;
    }

    public void setScenario(Deque<ClientEvent> scenario) {
        this.scenario = scenario;
    }

    public void setCtx(ChannelHandlerContext ctx) {
        this.ctx = ctx;
    }

    public void addOcpMsg(byte[] message) {
        this.ocpMsg.add(message);
    }

    public boolean isScenarioFinished() {
        return this.scenarioFinished;
    }
}

