/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.ocpjava.protocol.impl.clients;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import org.opendaylight.ocpjava.protocol.impl.clients.ClientEvent;
import org.opendaylight.ocpjava.util.ByteBufUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendEvent
implements ClientEvent {
    protected static final Logger LOGGER = LoggerFactory.getLogger(SendEvent.class);
    protected byte[] msgToSend;
    protected ChannelHandlerContext ctx;

    public SendEvent(byte[] msgToSend) {
        LOGGER.debug("SendEvent init");
        this.msgToSend = new byte[msgToSend.length];
        for (int i = 0; i < msgToSend.length; ++i) {
            this.msgToSend[i] = msgToSend[i];
        }
    }

    @Override
    public boolean eventExecuted() {
        LOGGER.debug("sending message");
        LOGGER.debug("start of run");
        ByteBuf buffer = this.ctx.alloc().buffer();
        buffer.writeBytes(this.msgToSend);
        this.ctx.writeAndFlush((Object)buffer);
        if (LOGGER.isDebugEnabled()) {
            try {
                String buf = new String(this.msgToSend, "UTF-8");
                LOGGER.debug(">> {}", (Object)buf);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            LOGGER.debug(">> {}", (Object)ByteBufUtils.bytesToHexString((byte[])this.msgToSend));
            LOGGER.debug("message sent");
        }
        return true;
    }

    public void setCtx(ChannelHandlerContext ctx) {
        this.ctx = ctx;
    }
}

