/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.ocpjava.protocol.impl.clients;

import com.google.common.util.concurrent.SettableFuture;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.concurrent.Future;
import java.net.InetAddress;
import java.util.concurrent.ExecutionException;
import org.opendaylight.ocpjava.protocol.impl.clients.OCPClient;
import org.opendaylight.ocpjava.protocol.impl.clients.ScenarioHandler;
import org.opendaylight.ocpjava.protocol.impl.clients.SimpleClientInitializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleClient
implements OCPClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleClient.class);
    private final String host;
    private final int port;
    private boolean securedClient = false;
    private EventLoopGroup group;
    private SettableFuture<Boolean> isOnlineFuture;
    private SettableFuture<Boolean> scenarioDone;
    private ScenarioHandler scenarioHandler;

    public SimpleClient(String host, int port) {
        this.host = host;
        this.port = port;
        this.init();
    }

    private void init() {
        this.isOnlineFuture = SettableFuture.create();
        this.scenarioDone = SettableFuture.create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.group = new NioEventLoopGroup();
        SimpleClientInitializer clientInitializer = new SimpleClientInitializer(this.isOnlineFuture, this.securedClient);
        clientInitializer.setScenario(this.scenarioHandler);
        try {
            Bootstrap b = new Bootstrap();
            ((Bootstrap)((Bootstrap)b.group(this.group)).channel(NioSocketChannel.class)).handler((ChannelHandler)clientInitializer);
            b.connect(this.host, this.port).sync();
            ScenarioHandler scenarioHandler = this.scenarioHandler;
            synchronized (scenarioHandler) {
                LOGGER.debug("WAITING FOR SCENARIO");
                while (!this.scenarioHandler.isScenarioFinished()) {
                    this.scenarioHandler.wait();
                }
            }
        }
        catch (Exception ex) {
            LOGGER.error(ex.getMessage(), (Throwable)ex);
        }
        finally {
            LOGGER.debug("shutting down");
            try {
                this.group.shutdownGracefully().get();
                LOGGER.debug("shutdown succesful");
            }
            catch (InterruptedException | ExecutionException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        this.scenarioDone.set((Object)true);
    }

    public Future<?> disconnect() {
        LOGGER.debug("disconnecting client");
        return this.group.shutdownGracefully();
    }

    @Override
    public void setSecuredClient(boolean securedClient) {
        this.securedClient = securedClient;
    }

    public static void main(String[] args) throws Exception {
        SimpleClient sc;
        if (args.length != 3) {
            LOGGER.error("Usage: {} <host> <port> <secured>", (Object)SimpleClient.class.getSimpleName());
            LOGGER.error("Trying to use default setting.");
            InetAddress ia = InetAddress.getLocalHost();
            InetAddress[] all = InetAddress.getAllByName(ia.getHostName());
            String host = all[0].getHostAddress();
            int port = 6633;
            sc = new SimpleClient(host, port);
            sc.setSecuredClient(true);
        } else {
            String host = args[0];
            int port = Integer.parseInt(args[1]);
            sc = new SimpleClient(host, port);
            sc.setSecuredClient(Boolean.parseBoolean(args[2]));
        }
        sc.run();
    }

    @Override
    public SettableFuture<Boolean> getIsOnlineFuture() {
        return this.isOnlineFuture;
    }

    @Override
    public SettableFuture<Boolean> getScenarioDone() {
        return this.scenarioDone;
    }

    @Override
    public void setScenarioHandler(ScenarioHandler scenario) {
        this.scenarioHandler = scenario;
    }
}

