/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.ocpjava.protocol.impl.clients;

import com.google.common.util.concurrent.SettableFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import org.opendaylight.ocpjava.protocol.impl.clients.ScenarioHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleClientHandler
extends ChannelInboundHandlerAdapter {
    protected static final Logger LOGGER = LoggerFactory.getLogger(SimpleClientHandler.class);
    private SettableFuture<Boolean> isOnlineFuture;
    protected ScenarioHandler scenarioHandler;

    public SimpleClientHandler(SettableFuture<Boolean> isOnlineFuture, ScenarioHandler scenarioHandler) {
        this.isOnlineFuture = isOnlineFuture;
        this.scenarioHandler = scenarioHandler;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        LOGGER.debug("channel Read message: " + msg);
        byte[] bs = (byte[])msg;
        this.scenarioHandler.addOcpMsg(bs);
        String buf = new String(bs, "UTF-8");
        LOGGER.debug("<< {}", (Object)buf);
        LOGGER.debug("end of read");
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        LOGGER.debug("Client1 is active");
        if (this.isOnlineFuture != null) {
            this.isOnlineFuture.set((Object)true);
            this.isOnlineFuture = null;
        }
        this.scenarioHandler.setCtx(ctx);
        this.scenarioHandler.start();
    }

    public void setScenario(ScenarioHandler scenarioHandler) {
        this.scenarioHandler = scenarioHandler;
    }
}

