/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.ocpjava.protocol.impl.clients;

import org.opendaylight.ocpjava.protocol.impl.clients.ClientEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SleepEvent
implements ClientEvent {
    private static final Logger LOGGER = LoggerFactory.getLogger(SleepEvent.class);
    private long sleepTime;

    public SleepEvent(long sleepTime) {
        this.sleepTime = sleepTime;
    }

    @Override
    public boolean eventExecuted() {
        try {
            Thread.sleep(this.sleepTime);
            LOGGER.debug("Sleeping");
            return true;
        }
        catch (InterruptedException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }
}

