/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.ocpjava.protocol.impl.clients;

import java.util.Arrays;
import org.opendaylight.ocpjava.protocol.impl.clients.ClientEvent;
import org.opendaylight.ocpjava.util.ByteBufUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WaitForMessageEvent
implements ClientEvent {
    private static final Logger LOGGER = LoggerFactory.getLogger(WaitForMessageEvent.class);
    private byte[] messageExpected;
    private byte[] messageReceived;

    public WaitForMessageEvent(byte[] messageExpected) {
        LOGGER.debug("WaitForMessageEvent init");
        LOGGER.debug("headerExpected length: {}", (Object)messageExpected.length);
        this.messageExpected = new byte[messageExpected.length];
        for (int i = 0; i < messageExpected.length; ++i) {
            this.messageExpected[i] = messageExpected[i];
        }
    }

    @Override
    public boolean eventExecuted() {
        if (this.messageReceived == null) {
            return false;
        }
        if (!Arrays.equals(this.messageExpected, this.messageReceived)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("expected msg: {}", (Object)ByteBufUtils.bytesToHexString((byte[])this.messageExpected));
                LOGGER.debug("received msg: {}", (Object)ByteBufUtils.bytesToHexString((byte[])this.messageReceived));
            }
            return false;
        }
        LOGGER.debug("Headers OK");
        return true;
    }

    public void setHeaderReceived(byte[] messageReceived) {
        this.messageReceived = new byte[messageReceived.length];
        for (int i = 0; i < messageReceived.length; ++i) {
            this.messageReceived[i] = messageReceived[i];
        }
    }
}

