/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.approved.extensions.rev160802.oxm.container.match.entry.value.experimenter.id._case;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.approved.extensions.rev160802.oxm.container.match.entry.value.experimenter.id._case.TcpFlags;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class TcpFlagsBuilder
implements Builder<TcpFlags> {
    private Integer _flags;
    private byte[] _mask;
    Map<Class<? extends Augmentation<TcpFlags>>, Augmentation<TcpFlags>> augmentation = Collections.emptyMap();

    public TcpFlagsBuilder() {
    }

    public TcpFlagsBuilder(TcpFlags base) {
        AugmentationHolder casted;
        this._flags = base.getFlags();
        this._mask = base.getMask();
        if (base instanceof TcpFlagsImpl) {
            TcpFlagsImpl impl = (TcpFlagsImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<TcpFlags>>, Augmentation<TcpFlags>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<TcpFlags>>, Augmentation<TcpFlags>>(casted.augmentations());
        }
    }

    public Integer getFlags() {
        return this._flags;
    }

    public byte[] getMask() {
        return this._mask == null ? null : (byte[])this._mask.clone();
    }

    public <E extends Augmentation<TcpFlags>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkFlagsRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public TcpFlagsBuilder setFlags(Integer value) {
        if (value != null) {
            TcpFlagsBuilder.checkFlagsRange(value);
        }
        this._flags = value;
        return this;
    }

    public TcpFlagsBuilder setMask(byte[] value) {
        this._mask = value;
        return this;
    }

    public TcpFlagsBuilder addAugmentation(Class<? extends Augmentation<TcpFlags>> augmentationType, Augmentation<TcpFlags> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<TcpFlags>>, Augmentation<TcpFlags>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public TcpFlagsBuilder removeAugmentation(Class<? extends Augmentation<TcpFlags>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public TcpFlags build() {
        return new TcpFlagsImpl(this);
    }

    private static final class TcpFlagsImpl
    implements TcpFlags {
        private final Integer _flags;
        private final byte[] _mask;
        private Map<Class<? extends Augmentation<TcpFlags>>, Augmentation<TcpFlags>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<TcpFlags> getImplementedInterface() {
            return TcpFlags.class;
        }

        private TcpFlagsImpl(TcpFlagsBuilder base) {
            this._flags = base.getFlags();
            this._mask = base.getMask();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<TcpFlags>>, Augmentation<TcpFlags>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<TcpFlags>>, Augmentation<TcpFlags>>(base.augmentation);
                }
            }
        }

        @Override
        public Integer getFlags() {
            return this._flags;
        }

        @Override
        public byte[] getMask() {
            return this._mask == null ? null : (byte[])this._mask.clone();
        }

        public <E extends Augmentation<TcpFlags>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._flags);
            result = 31 * result + Arrays.hashCode(this._mask);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!TcpFlags.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            TcpFlags other = (TcpFlags)obj;
            if (!Objects.equals(this._flags, other.getFlags())) {
                return false;
            }
            if (!Arrays.equals(this._mask, other.getMask())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                TcpFlagsImpl otherImpl = (TcpFlagsImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<TcpFlags>>, Augmentation<TcpFlags>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("TcpFlags [");
            boolean first = true;
            if (this._flags != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_flags=");
                builder.append(this._flags);
            }
            if (this._mask != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_mask=");
                builder.append(Arrays.toString(this._mask));
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

