/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev150225;

import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev150225.ExperimenterIdTableFeatureProperty;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.ExperimenterId;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ExperimenterIdTableFeaturePropertyBuilder
implements Builder<ExperimenterIdTableFeatureProperty> {
    private Long _expType;
    private ExperimenterId _experimenter;

    public ExperimenterIdTableFeaturePropertyBuilder() {
    }

    public ExperimenterIdTableFeaturePropertyBuilder(ExperimenterIdTableFeatureProperty base) {
        this._expType = base.getExpType();
        this._experimenter = base.getExperimenter();
    }

    public Long getExpType() {
        return this._expType;
    }

    public ExperimenterId getExperimenter() {
        return this._experimenter;
    }

    private static void checkExpTypeRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public ExperimenterIdTableFeaturePropertyBuilder setExpType(Long value) {
        if (value != null) {
            ExperimenterIdTableFeaturePropertyBuilder.checkExpTypeRange(value);
        }
        this._expType = value;
        return this;
    }

    public ExperimenterIdTableFeaturePropertyBuilder setExperimenter(ExperimenterId value) {
        this._experimenter = value;
        return this;
    }

    public ExperimenterIdTableFeatureProperty build() {
        return new ExperimenterIdTableFeaturePropertyImpl(this);
    }

    private static final class ExperimenterIdTableFeaturePropertyImpl
    implements ExperimenterIdTableFeatureProperty {
        private final Long _expType;
        private final ExperimenterId _experimenter;
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<ExperimenterIdTableFeatureProperty> getImplementedInterface() {
            return ExperimenterIdTableFeatureProperty.class;
        }

        private ExperimenterIdTableFeaturePropertyImpl(ExperimenterIdTableFeaturePropertyBuilder base) {
            this._expType = base.getExpType();
            this._experimenter = base.getExperimenter();
        }

        @Override
        public Long getExpType() {
            return this._expType;
        }

        @Override
        public ExperimenterId getExperimenter() {
            return this._experimenter;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._expType);
            this.hash = result = 31 * result + Objects.hashCode(this._experimenter);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!ExperimenterIdTableFeatureProperty.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            ExperimenterIdTableFeatureProperty other = (ExperimenterIdTableFeatureProperty)obj;
            if (!Objects.equals(this._expType, other.getExpType())) {
                return false;
            }
            return Objects.equals(this._experimenter, other.getExperimenter());
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("ExperimenterIdTableFeatureProperty [");
            boolean first = true;
            if (this._expType != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_expType=");
                builder.append(this._expType);
            }
            if (this._experimenter != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_experimenter=");
                builder.append(this._experimenter);
            }
            return builder.append(']').toString();
        }
    }
}

