/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev150225;

import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev150225.RateQueueProperty;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class RateQueuePropertyBuilder
implements Builder<RateQueueProperty> {
    private Integer _rate;

    public RateQueuePropertyBuilder() {
    }

    public RateQueuePropertyBuilder(RateQueueProperty base) {
        this._rate = base.getRate();
    }

    public Integer getRate() {
        return this._rate;
    }

    private static void checkRateRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public RateQueuePropertyBuilder setRate(Integer value) {
        if (value != null) {
            RateQueuePropertyBuilder.checkRateRange(value);
        }
        this._rate = value;
        return this;
    }

    public RateQueueProperty build() {
        return new RateQueuePropertyImpl(this);
    }

    private static final class RateQueuePropertyImpl
    implements RateQueueProperty {
        private final Integer _rate;
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<RateQueueProperty> getImplementedInterface() {
            return RateQueueProperty.class;
        }

        private RateQueuePropertyImpl(RateQueuePropertyBuilder base) {
            this._rate = base.getRate();
        }

        @Override
        public Integer getRate() {
            return this._rate;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            this.hash = result = 31 * result + Objects.hashCode(this._rate);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!RateQueueProperty.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            RateQueueProperty other = (RateQueueProperty)obj;
            return Objects.equals(this._rate, other.getRate());
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("RateQueueProperty [");
            boolean first = true;
            if (this._rate != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_rate=");
                builder.append(this._rate);
            }
            return builder.append(']').toString();
        }
    }
}

