/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev150225.action.container.action.choice.experimenter.id._case;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev150225.action.container.action.choice.experimenter.id._case.Experimenter;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.ExperimenterActionSubType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.ExperimenterId;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ExperimenterBuilder
implements Builder<Experimenter> {
    private ExperimenterId _experimenter;
    private Class<? extends ExperimenterActionSubType> _subType;
    Map<Class<? extends Augmentation<Experimenter>>, Augmentation<Experimenter>> augmentation = Collections.emptyMap();

    public ExperimenterBuilder() {
    }

    public ExperimenterBuilder(Experimenter base) {
        AugmentationHolder casted;
        this._experimenter = base.getExperimenter();
        this._subType = base.getSubType();
        if (base instanceof ExperimenterImpl) {
            ExperimenterImpl impl = (ExperimenterImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Experimenter>>, Augmentation<Experimenter>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Experimenter>>, Augmentation<Experimenter>>(casted.augmentations());
        }
    }

    public ExperimenterId getExperimenter() {
        return this._experimenter;
    }

    public Class<? extends ExperimenterActionSubType> getSubType() {
        return this._subType;
    }

    public <E extends Augmentation<Experimenter>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public ExperimenterBuilder setExperimenter(ExperimenterId value) {
        this._experimenter = value;
        return this;
    }

    public ExperimenterBuilder setSubType(Class<? extends ExperimenterActionSubType> value) {
        this._subType = value;
        return this;
    }

    public ExperimenterBuilder addAugmentation(Class<? extends Augmentation<Experimenter>> augmentationType, Augmentation<Experimenter> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Experimenter>>, Augmentation<Experimenter>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public ExperimenterBuilder removeAugmentation(Class<? extends Augmentation<Experimenter>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Experimenter build() {
        return new ExperimenterImpl(this);
    }

    private static final class ExperimenterImpl
    implements Experimenter {
        private final ExperimenterId _experimenter;
        private final Class<? extends ExperimenterActionSubType> _subType;
        private Map<Class<? extends Augmentation<Experimenter>>, Augmentation<Experimenter>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Experimenter> getImplementedInterface() {
            return Experimenter.class;
        }

        private ExperimenterImpl(ExperimenterBuilder base) {
            this._experimenter = base.getExperimenter();
            this._subType = base.getSubType();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Experimenter>>, Augmentation<Experimenter>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Experimenter>>, Augmentation<Experimenter>>(base.augmentation);
                }
            }
        }

        @Override
        public ExperimenterId getExperimenter() {
            return this._experimenter;
        }

        @Override
        public Class<? extends ExperimenterActionSubType> getSubType() {
            return this._subType;
        }

        public <E extends Augmentation<Experimenter>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._experimenter);
            result = 31 * result + Objects.hashCode(this._subType);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Experimenter.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Experimenter other = (Experimenter)obj;
            if (!Objects.equals(this._experimenter, other.getExperimenter())) {
                return false;
            }
            if (!Objects.equals(this._subType, other.getSubType())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                ExperimenterImpl otherImpl = (ExperimenterImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Experimenter>>, Augmentation<Experimenter>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("Experimenter [");
            boolean first = true;
            if (this._experimenter != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_experimenter=");
                builder.append(this._experimenter);
            }
            if (this._subType != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_subType=");
                builder.append(this._subType);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

