/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.enqueue._case;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.enqueue._case.EnqueueAction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.QueueId;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class EnqueueActionBuilder
implements Builder<EnqueueAction> {
    private PortNumber _port;
    private QueueId _queueId;
    Map<Class<? extends Augmentation<EnqueueAction>>, Augmentation<EnqueueAction>> augmentation = Collections.emptyMap();

    public EnqueueActionBuilder() {
    }

    public EnqueueActionBuilder(EnqueueAction base) {
        AugmentationHolder casted;
        this._port = base.getPort();
        this._queueId = base.getQueueId();
        if (base instanceof EnqueueActionImpl) {
            EnqueueActionImpl impl = (EnqueueActionImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<EnqueueAction>>, Augmentation<EnqueueAction>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<EnqueueAction>>, Augmentation<EnqueueAction>>(casted.augmentations());
        }
    }

    public PortNumber getPort() {
        return this._port;
    }

    public QueueId getQueueId() {
        return this._queueId;
    }

    public <E extends Augmentation<EnqueueAction>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public EnqueueActionBuilder setPort(PortNumber value) {
        this._port = value;
        return this;
    }

    public EnqueueActionBuilder setQueueId(QueueId value) {
        this._queueId = value;
        return this;
    }

    public EnqueueActionBuilder addAugmentation(Class<? extends Augmentation<EnqueueAction>> augmentationType, Augmentation<EnqueueAction> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<EnqueueAction>>, Augmentation<EnqueueAction>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public EnqueueActionBuilder removeAugmentation(Class<? extends Augmentation<EnqueueAction>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public EnqueueAction build() {
        return new EnqueueActionImpl(this);
    }

    private static final class EnqueueActionImpl
    implements EnqueueAction {
        private final PortNumber _port;
        private final QueueId _queueId;
        private Map<Class<? extends Augmentation<EnqueueAction>>, Augmentation<EnqueueAction>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<EnqueueAction> getImplementedInterface() {
            return EnqueueAction.class;
        }

        private EnqueueActionImpl(EnqueueActionBuilder base) {
            this._port = base.getPort();
            this._queueId = base.getQueueId();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<EnqueueAction>>, Augmentation<EnqueueAction>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<EnqueueAction>>, Augmentation<EnqueueAction>>(base.augmentation);
                }
            }
        }

        @Override
        public PortNumber getPort() {
            return this._port;
        }

        @Override
        public QueueId getQueueId() {
            return this._queueId;
        }

        public <E extends Augmentation<EnqueueAction>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._port);
            result = 31 * result + Objects.hashCode(this._queueId);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!EnqueueAction.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            EnqueueAction other = (EnqueueAction)obj;
            if (!Objects.equals(this._port, other.getPort())) {
                return false;
            }
            if (!Objects.equals(this._queueId, other.getQueueId())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                EnqueueActionImpl otherImpl = (EnqueueActionImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<EnqueueAction>>, Augmentation<EnqueueAction>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("EnqueueAction [");
            boolean first = true;
            if (this._port != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_port=");
                builder.append(this._port);
            }
            if (this._queueId != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_queueId=");
                builder.append(this._queueId);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

