/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.group._case;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.group._case.GroupAction;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class GroupActionBuilder
implements Builder<GroupAction> {
    private Long _groupId;
    Map<Class<? extends Augmentation<GroupAction>>, Augmentation<GroupAction>> augmentation = Collections.emptyMap();

    public GroupActionBuilder() {
    }

    public GroupActionBuilder(GroupAction base) {
        AugmentationHolder casted;
        this._groupId = base.getGroupId();
        if (base instanceof GroupActionImpl) {
            GroupActionImpl impl = (GroupActionImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<GroupAction>>, Augmentation<GroupAction>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<GroupAction>>, Augmentation<GroupAction>>(casted.augmentations());
        }
    }

    public Long getGroupId() {
        return this._groupId;
    }

    public <E extends Augmentation<GroupAction>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkGroupIdRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public GroupActionBuilder setGroupId(Long value) {
        if (value != null) {
            GroupActionBuilder.checkGroupIdRange(value);
        }
        this._groupId = value;
        return this;
    }

    public GroupActionBuilder addAugmentation(Class<? extends Augmentation<GroupAction>> augmentationType, Augmentation<GroupAction> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<GroupAction>>, Augmentation<GroupAction>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public GroupActionBuilder removeAugmentation(Class<? extends Augmentation<GroupAction>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public GroupAction build() {
        return new GroupActionImpl(this);
    }

    private static final class GroupActionImpl
    implements GroupAction {
        private final Long _groupId;
        private Map<Class<? extends Augmentation<GroupAction>>, Augmentation<GroupAction>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<GroupAction> getImplementedInterface() {
            return GroupAction.class;
        }

        private GroupActionImpl(GroupActionBuilder base) {
            this._groupId = base.getGroupId();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<GroupAction>>, Augmentation<GroupAction>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<GroupAction>>, Augmentation<GroupAction>>(base.augmentation);
                }
            }
        }

        @Override
        public Long getGroupId() {
            return this._groupId;
        }

        public <E extends Augmentation<GroupAction>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._groupId);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!GroupAction.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            GroupAction other = (GroupAction)obj;
            if (!Objects.equals(this._groupId, other.getGroupId())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                GroupActionImpl otherImpl = (GroupActionImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<GroupAction>>, Augmentation<GroupAction>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("GroupAction [");
            boolean first = true;
            if (this._groupId != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_groupId=");
                builder.append(this._groupId);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

