/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.output.action._case;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.output.action._case.OutputAction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortNumber;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class OutputActionBuilder
implements Builder<OutputAction> {
    private Integer _maxLength;
    private PortNumber _port;
    Map<Class<? extends Augmentation<OutputAction>>, Augmentation<OutputAction>> augmentation = Collections.emptyMap();

    public OutputActionBuilder() {
    }

    public OutputActionBuilder(OutputAction base) {
        AugmentationHolder casted;
        this._maxLength = base.getMaxLength();
        this._port = base.getPort();
        if (base instanceof OutputActionImpl) {
            OutputActionImpl impl = (OutputActionImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<OutputAction>>, Augmentation<OutputAction>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<OutputAction>>, Augmentation<OutputAction>>(casted.augmentations());
        }
    }

    public Integer getMaxLength() {
        return this._maxLength;
    }

    public PortNumber getPort() {
        return this._port;
    }

    public <E extends Augmentation<OutputAction>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkMaxLengthRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public OutputActionBuilder setMaxLength(Integer value) {
        if (value != null) {
            OutputActionBuilder.checkMaxLengthRange(value);
        }
        this._maxLength = value;
        return this;
    }

    public OutputActionBuilder setPort(PortNumber value) {
        this._port = value;
        return this;
    }

    public OutputActionBuilder addAugmentation(Class<? extends Augmentation<OutputAction>> augmentationType, Augmentation<OutputAction> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<OutputAction>>, Augmentation<OutputAction>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public OutputActionBuilder removeAugmentation(Class<? extends Augmentation<OutputAction>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public OutputAction build() {
        return new OutputActionImpl(this);
    }

    private static final class OutputActionImpl
    implements OutputAction {
        private final Integer _maxLength;
        private final PortNumber _port;
        private Map<Class<? extends Augmentation<OutputAction>>, Augmentation<OutputAction>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<OutputAction> getImplementedInterface() {
            return OutputAction.class;
        }

        private OutputActionImpl(OutputActionBuilder base) {
            this._maxLength = base.getMaxLength();
            this._port = base.getPort();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<OutputAction>>, Augmentation<OutputAction>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<OutputAction>>, Augmentation<OutputAction>>(base.augmentation);
                }
            }
        }

        @Override
        public Integer getMaxLength() {
            return this._maxLength;
        }

        @Override
        public PortNumber getPort() {
            return this._port;
        }

        public <E extends Augmentation<OutputAction>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._maxLength);
            result = 31 * result + Objects.hashCode(this._port);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!OutputAction.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            OutputAction other = (OutputAction)obj;
            if (!Objects.equals(this._maxLength, other.getMaxLength())) {
                return false;
            }
            if (!Objects.equals(this._port, other.getPort())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                OutputActionImpl otherImpl = (OutputActionImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<OutputAction>>, Augmentation<OutputAction>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("OutputAction [");
            boolean first = true;
            if (this._maxLength != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_maxLength=");
                builder.append(this._maxLength);
            }
            if (this._port != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_port=");
                builder.append(this._port);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

