/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.set.queue._case;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.set.queue._case.SetQueueAction;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class SetQueueActionBuilder
implements Builder<SetQueueAction> {
    private Long _queueId;
    Map<Class<? extends Augmentation<SetQueueAction>>, Augmentation<SetQueueAction>> augmentation = Collections.emptyMap();

    public SetQueueActionBuilder() {
    }

    public SetQueueActionBuilder(SetQueueAction base) {
        AugmentationHolder casted;
        this._queueId = base.getQueueId();
        if (base instanceof SetQueueActionImpl) {
            SetQueueActionImpl impl = (SetQueueActionImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<SetQueueAction>>, Augmentation<SetQueueAction>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<SetQueueAction>>, Augmentation<SetQueueAction>>(casted.augmentations());
        }
    }

    public Long getQueueId() {
        return this._queueId;
    }

    public <E extends Augmentation<SetQueueAction>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkQueueIdRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public SetQueueActionBuilder setQueueId(Long value) {
        if (value != null) {
            SetQueueActionBuilder.checkQueueIdRange(value);
        }
        this._queueId = value;
        return this;
    }

    public SetQueueActionBuilder addAugmentation(Class<? extends Augmentation<SetQueueAction>> augmentationType, Augmentation<SetQueueAction> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<SetQueueAction>>, Augmentation<SetQueueAction>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public SetQueueActionBuilder removeAugmentation(Class<? extends Augmentation<SetQueueAction>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public SetQueueAction build() {
        return new SetQueueActionImpl(this);
    }

    private static final class SetQueueActionImpl
    implements SetQueueAction {
        private final Long _queueId;
        private Map<Class<? extends Augmentation<SetQueueAction>>, Augmentation<SetQueueAction>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<SetQueueAction> getImplementedInterface() {
            return SetQueueAction.class;
        }

        private SetQueueActionImpl(SetQueueActionBuilder base) {
            this._queueId = base.getQueueId();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<SetQueueAction>>, Augmentation<SetQueueAction>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<SetQueueAction>>, Augmentation<SetQueueAction>>(base.augmentation);
                }
            }
        }

        @Override
        public Long getQueueId() {
            return this._queueId;
        }

        public <E extends Augmentation<SetQueueAction>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._queueId);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!SetQueueAction.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            SetQueueAction other = (SetQueueAction)obj;
            if (!Objects.equals(this._queueId, other.getQueueId())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                SetQueueActionImpl otherImpl = (SetQueueActionImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<SetQueueAction>>, Augmentation<SetQueueAction>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("SetQueueAction [");
            boolean first = true;
            if (this._queueId != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_queueId=");
                builder.append(this._queueId);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

