/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.set.vlan.pcp._case;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.set.vlan.pcp._case.SetVlanPcpAction;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class SetVlanPcpActionBuilder
implements Builder<SetVlanPcpAction> {
    private Short _vlanPcp;
    Map<Class<? extends Augmentation<SetVlanPcpAction>>, Augmentation<SetVlanPcpAction>> augmentation = Collections.emptyMap();

    public SetVlanPcpActionBuilder() {
    }

    public SetVlanPcpActionBuilder(SetVlanPcpAction base) {
        AugmentationHolder casted;
        this._vlanPcp = base.getVlanPcp();
        if (base instanceof SetVlanPcpActionImpl) {
            SetVlanPcpActionImpl impl = (SetVlanPcpActionImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<SetVlanPcpAction>>, Augmentation<SetVlanPcpAction>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<SetVlanPcpAction>>, Augmentation<SetVlanPcpAction>>(casted.augmentations());
        }
    }

    public Short getVlanPcp() {
        return this._vlanPcp;
    }

    public <E extends Augmentation<SetVlanPcpAction>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkVlanPcpRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u2025255]].", value));
    }

    public SetVlanPcpActionBuilder setVlanPcp(Short value) {
        if (value != null) {
            SetVlanPcpActionBuilder.checkVlanPcpRange(value);
        }
        this._vlanPcp = value;
        return this;
    }

    public SetVlanPcpActionBuilder addAugmentation(Class<? extends Augmentation<SetVlanPcpAction>> augmentationType, Augmentation<SetVlanPcpAction> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<SetVlanPcpAction>>, Augmentation<SetVlanPcpAction>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public SetVlanPcpActionBuilder removeAugmentation(Class<? extends Augmentation<SetVlanPcpAction>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public SetVlanPcpAction build() {
        return new SetVlanPcpActionImpl(this);
    }

    private static final class SetVlanPcpActionImpl
    implements SetVlanPcpAction {
        private final Short _vlanPcp;
        private Map<Class<? extends Augmentation<SetVlanPcpAction>>, Augmentation<SetVlanPcpAction>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<SetVlanPcpAction> getImplementedInterface() {
            return SetVlanPcpAction.class;
        }

        private SetVlanPcpActionImpl(SetVlanPcpActionBuilder base) {
            this._vlanPcp = base.getVlanPcp();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<SetVlanPcpAction>>, Augmentation<SetVlanPcpAction>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<SetVlanPcpAction>>, Augmentation<SetVlanPcpAction>>(base.augmentation);
                }
            }
        }

        @Override
        public Short getVlanPcp() {
            return this._vlanPcp;
        }

        public <E extends Augmentation<SetVlanPcpAction>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._vlanPcp);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!SetVlanPcpAction.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            SetVlanPcpAction other = (SetVlanPcpAction)obj;
            if (!Objects.equals(this._vlanPcp, other.getVlanPcp())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                SetVlanPcpActionImpl otherImpl = (SetVlanPcpActionImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<SetVlanPcpAction>>, Augmentation<SetVlanPcpAction>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("SetVlanPcpAction [");
            boolean first = true;
            if (this._vlanPcp != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_vlanPcp=");
                builder.append(this._vlanPcp);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

