/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.actions.grouping;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.ActionGrouping;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.ActionChoice;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.actions.grouping.Action;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.ExperimenterId;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ActionBuilder
implements Builder<Action> {
    private ActionChoice _actionChoice;
    private ExperimenterId _experimenterId;
    Map<Class<? extends Augmentation<Action>>, Augmentation<Action>> augmentation = Collections.emptyMap();

    public ActionBuilder() {
    }

    public ActionBuilder(ActionGrouping arg) {
        this._actionChoice = arg.getActionChoice();
    }

    public ActionBuilder(Action base) {
        AugmentationHolder casted;
        this._actionChoice = base.getActionChoice();
        this._experimenterId = base.getExperimenterId();
        if (base instanceof ActionImpl) {
            ActionImpl impl = (ActionImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Action>>, Augmentation<Action>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Action>>, Augmentation<Action>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof ActionGrouping) {
            this._actionChoice = ((ActionGrouping)arg).getActionChoice();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.ActionGrouping] \nbut was: " + arg);
        }
    }

    public ActionChoice getActionChoice() {
        return this._actionChoice;
    }

    public ExperimenterId getExperimenterId() {
        return this._experimenterId;
    }

    public <E extends Augmentation<Action>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public ActionBuilder setActionChoice(ActionChoice value) {
        this._actionChoice = value;
        return this;
    }

    public ActionBuilder setExperimenterId(ExperimenterId value) {
        this._experimenterId = value;
        return this;
    }

    public ActionBuilder addAugmentation(Class<? extends Augmentation<Action>> augmentationType, Augmentation<Action> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Action>>, Augmentation<Action>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public ActionBuilder removeAugmentation(Class<? extends Augmentation<Action>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Action build() {
        return new ActionImpl(this);
    }

    private static final class ActionImpl
    implements Action {
        private final ActionChoice _actionChoice;
        private final ExperimenterId _experimenterId;
        private Map<Class<? extends Augmentation<Action>>, Augmentation<Action>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Action> getImplementedInterface() {
            return Action.class;
        }

        private ActionImpl(ActionBuilder base) {
            this._actionChoice = base.getActionChoice();
            this._experimenterId = base.getExperimenterId();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Action>>, Augmentation<Action>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Action>>, Augmentation<Action>>(base.augmentation);
                }
            }
        }

        @Override
        public ActionChoice getActionChoice() {
            return this._actionChoice;
        }

        @Override
        public ExperimenterId getExperimenterId() {
            return this._experimenterId;
        }

        public <E extends Augmentation<Action>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._actionChoice);
            result = 31 * result + Objects.hashCode(this._experimenterId);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Action.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Action other = (Action)obj;
            if (!Objects.equals(this._actionChoice, other.getActionChoice())) {
                return false;
            }
            if (!Objects.equals(this._experimenterId, other.getExperimenterId())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                ActionImpl otherImpl = (ActionImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Action>>, Augmentation<Action>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("Action [");
            boolean first = true;
            if (this._actionChoice != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_actionChoice=");
                builder.append(this._actionChoice);
            }
            if (this._experimenterId != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_experimenterId=");
                builder.append(this._experimenterId);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

