/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.instruction.grouping.instruction.choice._goto.table._case;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.instruction.grouping.instruction.choice._goto.table._case.GotoTable;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class GotoTableBuilder
implements Builder<GotoTable> {
    private Short _tableId;
    Map<Class<? extends Augmentation<GotoTable>>, Augmentation<GotoTable>> augmentation = Collections.emptyMap();

    public GotoTableBuilder() {
    }

    public GotoTableBuilder(GotoTable base) {
        AugmentationHolder casted;
        this._tableId = base.getTableId();
        if (base instanceof GotoTableImpl) {
            GotoTableImpl impl = (GotoTableImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<GotoTable>>, Augmentation<GotoTable>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<GotoTable>>, Augmentation<GotoTable>>(casted.augmentations());
        }
    }

    public Short getTableId() {
        return this._tableId;
    }

    public <E extends Augmentation<GotoTable>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkTableIdRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u2025255]].", value));
    }

    public GotoTableBuilder setTableId(Short value) {
        if (value != null) {
            GotoTableBuilder.checkTableIdRange(value);
        }
        this._tableId = value;
        return this;
    }

    public GotoTableBuilder addAugmentation(Class<? extends Augmentation<GotoTable>> augmentationType, Augmentation<GotoTable> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<GotoTable>>, Augmentation<GotoTable>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public GotoTableBuilder removeAugmentation(Class<? extends Augmentation<GotoTable>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public GotoTable build() {
        return new GotoTableImpl(this);
    }

    private static final class GotoTableImpl
    implements GotoTable {
        private final Short _tableId;
        private Map<Class<? extends Augmentation<GotoTable>>, Augmentation<GotoTable>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<GotoTable> getImplementedInterface() {
            return GotoTable.class;
        }

        private GotoTableImpl(GotoTableBuilder base) {
            this._tableId = base.getTableId();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<GotoTable>>, Augmentation<GotoTable>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<GotoTable>>, Augmentation<GotoTable>>(base.augmentation);
                }
            }
        }

        @Override
        public Short getTableId() {
            return this._tableId;
        }

        public <E extends Augmentation<GotoTable>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._tableId);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!GotoTable.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            GotoTable other = (GotoTable)obj;
            if (!Objects.equals(this._tableId, other.getTableId())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                GotoTableImpl otherImpl = (GotoTableImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<GotoTable>>, Augmentation<GotoTable>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("GotoTable [");
            boolean first = true;
            if (this._tableId != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_tableId=");
                builder.append(this._tableId);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

