/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.instruction.grouping.instruction.choice.meter._case;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.instruction.grouping.instruction.choice.meter._case.Meter;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class MeterBuilder
implements Builder<Meter> {
    private Long _meterId;
    Map<Class<? extends Augmentation<Meter>>, Augmentation<Meter>> augmentation = Collections.emptyMap();

    public MeterBuilder() {
    }

    public MeterBuilder(Meter base) {
        AugmentationHolder casted;
        this._meterId = base.getMeterId();
        if (base instanceof MeterImpl) {
            MeterImpl impl = (MeterImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Meter>>, Augmentation<Meter>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Meter>>, Augmentation<Meter>>(casted.augmentations());
        }
    }

    public Long getMeterId() {
        return this._meterId;
    }

    public <E extends Augmentation<Meter>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkMeterIdRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public MeterBuilder setMeterId(Long value) {
        if (value != null) {
            MeterBuilder.checkMeterIdRange(value);
        }
        this._meterId = value;
        return this;
    }

    public MeterBuilder addAugmentation(Class<? extends Augmentation<Meter>> augmentationType, Augmentation<Meter> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Meter>>, Augmentation<Meter>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public MeterBuilder removeAugmentation(Class<? extends Augmentation<Meter>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Meter build() {
        return new MeterImpl(this);
    }

    private static final class MeterImpl
    implements Meter {
        private final Long _meterId;
        private Map<Class<? extends Augmentation<Meter>>, Augmentation<Meter>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Meter> getImplementedInterface() {
            return Meter.class;
        }

        private MeterImpl(MeterBuilder base) {
            this._meterId = base.getMeterId();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Meter>>, Augmentation<Meter>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Meter>>, Augmentation<Meter>>(base.augmentation);
                }
            }
        }

        @Override
        public Long getMeterId() {
            return this._meterId;
        }

        public <E extends Augmentation<Meter>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._meterId);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Meter.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Meter other = (Meter)obj;
            if (!Objects.equals(this._meterId, other.getMeterId())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                MeterImpl otherImpl = (MeterImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Meter>>, Augmentation<Meter>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("Meter [");
            boolean first = true;
            if (this._meterId != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_meterId=");
                builder.append(this._meterId);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

