/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.instructions.grouping;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.InstructionGrouping;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.instruction.grouping.InstructionChoice;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.instructions.grouping.Instruction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.ExperimenterId;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class InstructionBuilder
implements Builder<Instruction> {
    private ExperimenterId _experimenterId;
    private InstructionChoice _instructionChoice;
    Map<Class<? extends Augmentation<Instruction>>, Augmentation<Instruction>> augmentation = Collections.emptyMap();

    public InstructionBuilder() {
    }

    public InstructionBuilder(InstructionGrouping arg) {
        this._instructionChoice = arg.getInstructionChoice();
    }

    public InstructionBuilder(Instruction base) {
        AugmentationHolder casted;
        this._experimenterId = base.getExperimenterId();
        this._instructionChoice = base.getInstructionChoice();
        if (base instanceof InstructionImpl) {
            InstructionImpl impl = (InstructionImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Instruction>>, Augmentation<Instruction>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Instruction>>, Augmentation<Instruction>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof InstructionGrouping) {
            this._instructionChoice = ((InstructionGrouping)arg).getInstructionChoice();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.InstructionGrouping] \nbut was: " + arg);
        }
    }

    public ExperimenterId getExperimenterId() {
        return this._experimenterId;
    }

    public InstructionChoice getInstructionChoice() {
        return this._instructionChoice;
    }

    public <E extends Augmentation<Instruction>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public InstructionBuilder setExperimenterId(ExperimenterId value) {
        this._experimenterId = value;
        return this;
    }

    public InstructionBuilder setInstructionChoice(InstructionChoice value) {
        this._instructionChoice = value;
        return this;
    }

    public InstructionBuilder addAugmentation(Class<? extends Augmentation<Instruction>> augmentationType, Augmentation<Instruction> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Instruction>>, Augmentation<Instruction>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public InstructionBuilder removeAugmentation(Class<? extends Augmentation<Instruction>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Instruction build() {
        return new InstructionImpl(this);
    }

    private static final class InstructionImpl
    implements Instruction {
        private final ExperimenterId _experimenterId;
        private final InstructionChoice _instructionChoice;
        private Map<Class<? extends Augmentation<Instruction>>, Augmentation<Instruction>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Instruction> getImplementedInterface() {
            return Instruction.class;
        }

        private InstructionImpl(InstructionBuilder base) {
            this._experimenterId = base.getExperimenterId();
            this._instructionChoice = base.getInstructionChoice();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Instruction>>, Augmentation<Instruction>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Instruction>>, Augmentation<Instruction>>(base.augmentation);
                }
            }
        }

        @Override
        public ExperimenterId getExperimenterId() {
            return this._experimenterId;
        }

        @Override
        public InstructionChoice getInstructionChoice() {
            return this._instructionChoice;
        }

        public <E extends Augmentation<Instruction>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._experimenterId);
            result = 31 * result + Objects.hashCode(this._instructionChoice);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Instruction.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Instruction other = (Instruction)obj;
            if (!Objects.equals(this._experimenterId, other.getExperimenterId())) {
                return false;
            }
            if (!Objects.equals(this._instructionChoice, other.getInstructionChoice())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                InstructionImpl otherImpl = (InstructionImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Instruction>>, Augmentation<Instruction>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("Instruction [");
            boolean first = true;
            if (this._experimenterId != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_experimenterId=");
                builder.append(this._experimenterId);
            }
            if (this._instructionChoice != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_instructionChoice=");
                builder.append(this._instructionChoice);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

