/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731;

import com.google.common.collect.ImmutableMap;
import java.util.Map;

public enum BadActionCode {
    BADTYPE(0, "BAD_TYPE"),
    BADLEN(1, "BAD_LEN"),
    BADEXPERIMENTER(2, "BAD_EXPERIMENTER"),
    BADEXPTYPE(3, "BAD_EXP_TYPE"),
    BADOUTPORT(4, "BAD_OUT_PORT"),
    BADARGUMENT(5, "BAD_ARGUMENT"),
    EPERM(6, "EPERM"),
    TOOMANY(7, "TOO_MANY"),
    BADQUEUE(8, "BAD_QUEUE"),
    BADOUTGROUP(9, "BAD_OUT_GROUP"),
    MATCHINCONSISTENT(10, "MATCH_INCONSISTENT"),
    UNSUPPORTEDORDER(11, "UNSUPPORTED_ORDER"),
    BADTAG(12, "BAD_TAG"),
    BADSETTYPE(13, "BAD_SET_TYPE"),
    BADSETLEN(14, "BAD_SET_LEN"),
    BADSETARGUMENT(15, "BAD_SET_ARGUMENT");

    String name;
    int value;
    private static final Map<Integer, BadActionCode> VALUE_MAP;

    private BadActionCode(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public int getIntValue() {
        return this.value;
    }

    public static BadActionCode forValue(int valueArg) {
        return VALUE_MAP.get(valueArg);
    }

    static {
        ImmutableMap.Builder b = ImmutableMap.builder();
        for (BadActionCode enumItem : BadActionCode.values()) {
            b.put((Object)enumItem.value, (Object)enumItem);
        }
        VALUE_MAP = b.build();
    }
}

