/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731;

import com.google.common.collect.ImmutableMap;
import java.util.Map;

public enum BadInstructionCode {
    UNKNOWNINST(0, "UNKNOWN_INST"),
    UNSUPINST(1, "UNSUP_INST"),
    BADTABLEID(2, "BAD_TABLE_ID"),
    UNSUPMETADATA(3, "UNSUP_METADATA"),
    UNSUPMETADATAMASK(4, "UNSUP_METADATA_MASK"),
    BADEXPERIMENTER(5, "BAD_EXPERIMENTER"),
    BADEXPTYPE(6, "BAD_EXP_TYPE"),
    BADLEN(7, "BAD_LEN"),
    EPERM(8, "EPERM");

    String name;
    int value;
    private static final Map<Integer, BadInstructionCode> VALUE_MAP;

    private BadInstructionCode(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public int getIntValue() {
        return this.value;
    }

    public static BadInstructionCode forValue(int valueArg) {
        return VALUE_MAP.get(valueArg);
    }

    static {
        ImmutableMap.Builder b = ImmutableMap.builder();
        for (BadInstructionCode enumItem : BadInstructionCode.values()) {
            b.put((Object)enumItem.value, (Object)enumItem);
        }
        VALUE_MAP = b.build();
    }
}

