/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731;

import com.google.common.collect.ImmutableMap;
import java.util.Map;

public enum BadMatchCode {
    BADTYPE(0, "BAD_TYPE"),
    BADLEN(1, "BAD_LEN"),
    BADTAG(2, "BAD_TAG"),
    BADDLADDRMASK(3, "BAD_DL_ADDR_MASK"),
    BADNWADDRMASK(4, "BAD_NW_ADDR_MASK"),
    BADWILDCARDS(5, "BAD_WILDCARDS"),
    BADFIELD(6, "BAD_FIELD"),
    BADVALUE(7, "BAD_VALUE"),
    BADMASK(8, "BAD_MASK"),
    BADPREREQ(9, "BAD_PREREQ"),
    DUPFIELD(10, "DUP_FIELD"),
    EPERM(11, "EPERM");

    String name;
    int value;
    private static final Map<Integer, BadMatchCode> VALUE_MAP;

    private BadMatchCode(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public int getIntValue() {
        return this.value;
    }

    public static BadMatchCode forValue(int valueArg) {
        return VALUE_MAP.get(valueArg);
    }

    static {
        ImmutableMap.Builder b = ImmutableMap.builder();
        for (BadMatchCode enumItem : BadMatchCode.values()) {
            b.put((Object)enumItem.value, (Object)enumItem);
        }
        VALUE_MAP = b.build();
    }
}

