/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731;

import com.google.common.collect.ImmutableMap;
import java.util.Map;

public enum BadRequestCode {
    BADVERSION(0, "BAD_VERSION"),
    BADTYPE(1, "BAD_TYPE"),
    BADMULTIPART(2, "BAD_MULTIPART"),
    BADEXPERIMENTER(3, "BAD_EXPERIMENTER"),
    BADEXPTYPE(4, "BAD_EXP_TYPE"),
    EPERM(5, "EPERM"),
    BADLEN(6, "BAD_LEN"),
    BUFFEREMPTY(7, "BUFFER_EMPTY"),
    BUFFERUNKNOWN(8, "BUFFER_UNKNOWN"),
    BADTABLEID(9, "BAD_TABLE_ID"),
    ISSLAVE(10, "IS_SLAVE"),
    BADPORT(11, "BAD_PORT"),
    BADPACKET(12, "BAD_PACKET"),
    MULTIPARTBUFFEROVERFLOW(13, "MULTIPART_BUFFER_OVERFLOW");

    String name;
    int value;
    private static final Map<Integer, BadRequestCode> VALUE_MAP;

    private BadRequestCode(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public int getIntValue() {
        return this.value;
    }

    public static BadRequestCode forValue(int valueArg) {
        return VALUE_MAP.get(valueArg);
    }

    static {
        ImmutableMap.Builder b = ImmutableMap.builder();
        for (BadRequestCode enumItem : BadRequestCode.values()) {
            b.put((Object)enumItem.value, (Object)enumItem);
        }
        VALUE_MAP = b.build();
    }
}

