/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731;

import com.google.common.collect.ImmutableMap;
import java.util.Map;

public enum ErrorType {
    HELLOFAILED(0, "HELLO_FAILED"),
    BADREQUEST(1, "BAD_REQUEST"),
    BADACTION(2, "BAD_ACTION"),
    BADINSTRUCTION(3, "BAD_INSTRUCTION"),
    BADMATCH(4, "BAD_MATCH"),
    FLOWMODFAILED(5, "FLOW_MOD_FAILED"),
    GROUPMODFAILED(6, "GROUP_MOD_FAILED"),
    PORTMODFAILED(7, "PORT_MOD_FAILED"),
    TABLEMODFAILED(8, "TABLE_MOD_FAILED"),
    QUEUEOPFAILED(9, "QUEUE_OP_FAILED"),
    SWITCHCONFIGFAILED(10, "SWITCH_CONFIG_FAILED"),
    ROLEREQUESTFAILED(11, "ROLE_REQUEST_FAILED"),
    METERMODFAILED(12, "METER_MOD_FAILED"),
    TABLEFEATURESFAILED(13, "TABLE_FEATURES_FAILED"),
    EXPERIMENTER(65535, "EXPERIMENTER");

    String name;
    int value;
    private static final Map<Integer, ErrorType> VALUE_MAP;

    private ErrorType(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public int getIntValue() {
        return this.value;
    }

    public static ErrorType forValue(int valueArg) {
        return VALUE_MAP.get(valueArg);
    }

    static {
        ImmutableMap.Builder b = ImmutableMap.builder();
        for (ErrorType enumItem : ErrorType.values()) {
            b.put((Object)enumItem.value, (Object)enumItem);
        }
        VALUE_MAP = b.build();
    }
}

