/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731;

import com.google.common.collect.ImmutableMap;
import java.util.Map;

public enum FlowModCommand {
    OFPFCADD(0, "OFPFC_ADD"),
    OFPFCMODIFY(1, "OFPFC_MODIFY"),
    OFPFCMODIFYSTRICT(2, "OFPFC_MODIFY_STRICT"),
    OFPFCDELETE(3, "OFPFC_DELETE"),
    OFPFCDELETESTRICT(4, "OFPFC_DELETE_STRICT");

    String name;
    int value;
    private static final Map<Integer, FlowModCommand> VALUE_MAP;

    private FlowModCommand(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public int getIntValue() {
        return this.value;
    }

    public static FlowModCommand forValue(int valueArg) {
        return VALUE_MAP.get(valueArg);
    }

    static {
        ImmutableMap.Builder b = ImmutableMap.builder();
        for (FlowModCommand enumItem : FlowModCommand.values()) {
            b.put((Object)enumItem.value, (Object)enumItem);
        }
        VALUE_MAP = b.build();
    }
}

