/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731;

import com.google.common.collect.ImmutableMap;
import java.util.Map;

public enum Group {
    OFPGMAX(-256, "OFPG_MAX"),
    OFPGALL(-4, "OFPG_ALL"),
    OFPGANY(-1, "OFPG_ANY");

    String name;
    int value;
    private static final Map<Integer, Group> VALUE_MAP;

    private Group(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public int getIntValue() {
        return this.value;
    }

    public static Group forValue(int valueArg) {
        return VALUE_MAP.get(valueArg);
    }

    static {
        ImmutableMap.Builder b = ImmutableMap.builder();
        for (Group enumItem : Group.values()) {
            b.put((Object)enumItem.value, (Object)enumItem);
        }
        VALUE_MAP = b.build();
    }
}

