/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731;

import com.google.common.collect.ImmutableMap;
import java.util.Map;

public enum Meter {
    OFPMMAX(-65536, "OFPM_MAX"),
    OFPMSLOWPATH(-3, "OFPM_SLOWPATH"),
    OFPMCONTROLLER(-2, "OFPM_CONTROLLER"),
    OFPMALL(-1, "OFPM_ALL");

    String name;
    int value;
    private static final Map<Integer, Meter> VALUE_MAP;

    private Meter(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public int getIntValue() {
        return this.value;
    }

    public static Meter forValue(int valueArg) {
        return VALUE_MAP.get(valueArg);
    }

    static {
        ImmutableMap.Builder b = ImmutableMap.builder();
        for (Meter enumItem : Meter.values()) {
            b.put((Object)enumItem.value, (Object)enumItem);
        }
        VALUE_MAP = b.build();
    }
}

