/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731;

import com.google.common.collect.ImmutableMap;
import java.util.Map;

public enum MeterBandType {
    OFPMBTDROP(1, "OFPMBT_DROP"),
    OFPMBTDSCPREMARK(2, "OFPMBT_DSCP_REMARK"),
    OFPMBTEXPERIMENTER(65535, "OFPMBT_EXPERIMENTER");

    String name;
    int value;
    private static final Map<Integer, MeterBandType> VALUE_MAP;

    private MeterBandType(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public int getIntValue() {
        return this.value;
    }

    public static MeterBandType forValue(int valueArg) {
        return VALUE_MAP.get(valueArg);
    }

    static {
        ImmutableMap.Builder b = ImmutableMap.builder();
        for (MeterBandType enumItem : MeterBandType.values()) {
            b.put((Object)enumItem.value, (Object)enumItem);
        }
        VALUE_MAP = b.build();
    }
}

