/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731;

import com.google.common.collect.ImmutableMap;
import java.util.Map;

public enum MultipartType {
    OFPMPDESC(0, "OFPMP_DESC"),
    OFPMPFLOW(1, "OFPMP_FLOW"),
    OFPMPAGGREGATE(2, "OFPMP_AGGREGATE"),
    OFPMPTABLE(3, "OFPMP_TABLE"),
    OFPMPPORTSTATS(4, "OFPMP_PORT_STATS"),
    OFPMPQUEUE(5, "OFPMP_QUEUE"),
    OFPMPGROUP(6, "OFPMP_GROUP"),
    OFPMPGROUPDESC(7, "OFPMP_GROUP_DESC"),
    OFPMPGROUPFEATURES(8, "OFPMP_GROUP_FEATURES"),
    OFPMPMETER(9, "OFPMP_METER"),
    OFPMPMETERCONFIG(10, "OFPMP_METER_CONFIG"),
    OFPMPMETERFEATURES(11, "OFPMP_METER_FEATURES"),
    OFPMPTABLEFEATURES(12, "OFPMP_TABLE_FEATURES"),
    OFPMPPORTDESC(13, "OFPMP_PORT_DESC"),
    OFPMPEXPERIMENTER(65535, "OFPMP_EXPERIMENTER");

    String name;
    int value;
    private static final Map<Integer, MultipartType> VALUE_MAP;

    private MultipartType(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public int getIntValue() {
        return this.value;
    }

    public static MultipartType forValue(int valueArg) {
        return VALUE_MAP.get(valueArg);
    }

    static {
        ImmutableMap.Builder b = ImmutableMap.builder();
        for (MultipartType enumItem : MultipartType.values()) {
            b.put((Object)enumItem.value, (Object)enumItem);
        }
        VALUE_MAP = b.build();
    }
}

