/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731;

import com.google.common.collect.ImmutableMap;
import java.util.Map;

public enum PacketInReason {
    OFPRNOMATCH(0, "OFPR_NO_MATCH"),
    OFPRACTION(1, "OFPR_ACTION"),
    OFPRINVALIDTTL(2, "OFPR_INVALID_TTL");

    String name;
    int value;
    private static final Map<Integer, PacketInReason> VALUE_MAP;

    private PacketInReason(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public int getIntValue() {
        return this.value;
    }

    public static PacketInReason forValue(int valueArg) {
        return VALUE_MAP.get(valueArg);
    }

    static {
        ImmutableMap.Builder b = ImmutableMap.builder();
        for (PacketInReason enumItem : PacketInReason.values()) {
            b.put((Object)enumItem.value, (Object)enumItem);
        }
        VALUE_MAP = b.build();
    }
}

