/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Objects;

public class PortConfig
implements Serializable {
    private static final long serialVersionUID = 1874024774086258120L;
    private final Boolean _portDown;
    private final Boolean _noRecv;
    private final Boolean _noFwd;
    private final Boolean _noPacketIn;

    public PortConfig(Boolean _noFwd, Boolean _noPacketIn, Boolean _noRecv, Boolean _portDown) {
        this._portDown = _portDown;
        this._noRecv = _noRecv;
        this._noFwd = _noFwd;
        this._noPacketIn = _noPacketIn;
    }

    public PortConfig(PortConfig source) {
        this._portDown = source._portDown;
        this._noRecv = source._noRecv;
        this._noFwd = source._noFwd;
        this._noPacketIn = source._noPacketIn;
    }

    public static PortConfig getDefaultInstance(String defaultValue) {
        ArrayList properties = Lists.newArrayList((Object[])new String[]{"noFwd", "noPacketIn", "noRecv", "portDown"});
        if (!properties.contains(defaultValue)) {
            throw new IllegalArgumentException("invalid default parameter");
        }
        int i = 0;
        return new PortConfig(((String)properties.get(i++)).equals(defaultValue) ? Boolean.TRUE : null, ((String)properties.get(i++)).equals(defaultValue) ? Boolean.TRUE : null, ((String)properties.get(i++)).equals(defaultValue) ? Boolean.TRUE : null, ((String)properties.get(i++)).equals(defaultValue) ? Boolean.TRUE : null);
    }

    public Boolean isPortDown() {
        return this._portDown;
    }

    public Boolean isNoRecv() {
        return this._noRecv;
    }

    public Boolean isNoFwd() {
        return this._noFwd;
    }

    public Boolean isNoPacketIn() {
        return this._noPacketIn;
    }

    public boolean[] getValue() {
        return new boolean[]{this._portDown, this._noRecv, this._noFwd, this._noPacketIn};
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Objects.hashCode(this._portDown);
        result = 31 * result + Objects.hashCode(this._noRecv);
        result = 31 * result + Objects.hashCode(this._noFwd);
        result = 31 * result + Objects.hashCode(this._noPacketIn);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PortConfig other = (PortConfig)obj;
        if (!Objects.equals(this._portDown, other._portDown)) {
            return false;
        }
        if (!Objects.equals(this._noRecv, other._noRecv)) {
            return false;
        }
        if (!Objects.equals(this._noFwd, other._noFwd)) {
            return false;
        }
        return Objects.equals(this._noPacketIn, other._noPacketIn);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(PortConfig.class.getSimpleName()).append(" [");
        boolean first = true;
        if (this._portDown != null) {
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("_portDown=");
            builder.append(this._portDown);
        }
        if (this._noRecv != null) {
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("_noRecv=");
            builder.append(this._noRecv);
        }
        if (this._noFwd != null) {
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("_noFwd=");
            builder.append(this._noFwd);
        }
        if (this._noPacketIn != null) {
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("_noPacketIn=");
            builder.append(this._noPacketIn);
        }
        return builder.append(']').toString();
    }
}

