/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731;

import com.google.common.collect.ImmutableMap;
import java.util.Map;

public enum PortNumberValues {
    MAX(-256, "MAX"),
    INPORT(-8, "IN_PORT"),
    TABLE(-7, "TABLE"),
    NORMAL(-6, "NORMAL"),
    FLOOD(-5, "FLOOD"),
    ALL(-4, "ALL"),
    CONTROLLER(-3, "CONTROLLER"),
    LOCAL(-2, "LOCAL"),
    ANY(-1, "ANY");

    String name;
    int value;
    private static final Map<Integer, PortNumberValues> VALUE_MAP;

    private PortNumberValues(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public int getIntValue() {
        return this.value;
    }

    public static PortNumberValues forValue(int valueArg) {
        return VALUE_MAP.get(valueArg);
    }

    static {
        ImmutableMap.Builder b = ImmutableMap.builder();
        for (PortNumberValues enumItem : PortNumberValues.values()) {
            b.put((Object)enumItem.value, (Object)enumItem);
        }
        VALUE_MAP = b.build();
    }
}

