/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731;

import com.google.common.collect.ImmutableMap;
import java.util.Map;

public enum PortNumberValuesV10 {
    MAX(65280, "MAX"),
    INPORT(65528, "IN_PORT"),
    TABLE(65529, "TABLE"),
    NORMAL(65530, "NORMAL"),
    FLOOD(65531, "FLOOD"),
    ALL(65532, "ALL"),
    CONTROLLER(65533, "CONTROLLER"),
    LOCAL(65534, "LOCAL"),
    NONE(65535, "NONE");

    String name;
    int value;
    private static final Map<Integer, PortNumberValuesV10> VALUE_MAP;

    private PortNumberValuesV10(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public int getIntValue() {
        return this.value;
    }

    public static PortNumberValuesV10 forValue(int valueArg) {
        return VALUE_MAP.get(valueArg);
    }

    static {
        ImmutableMap.Builder b = ImmutableMap.builder();
        for (PortNumberValuesV10 enumItem : PortNumberValuesV10.values()) {
            b.put((Object)enumItem.value, (Object)enumItem);
        }
        VALUE_MAP = b.build();
    }
}

