/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731;

import com.google.common.collect.ImmutableMap;
import java.util.Map;

public enum QueueProperties {
    OFPQTNONE(0, "OFPQT_NONE"),
    OFPQTMINRATE(1, "OFPQT_MIN_RATE"),
    OFPQTMAXRATE(2, "OFPQT_MAX_RATE"),
    OFPQTEXPERIMENTER(65535, "OFPQT_EXPERIMENTER");

    String name;
    int value;
    private static final Map<Integer, QueueProperties> VALUE_MAP;

    private QueueProperties(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public int getIntValue() {
        return this.value;
    }

    public static QueueProperties forValue(int valueArg) {
        return VALUE_MAP.get(valueArg);
    }

    static {
        ImmutableMap.Builder b = ImmutableMap.builder();
        for (QueueProperties enumItem : QueueProperties.values()) {
            b.put((Object)enumItem.value, (Object)enumItem);
        }
        VALUE_MAP = b.build();
    }
}

