/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731;

import com.google.common.collect.ImmutableMap;
import java.util.Map;

public enum SwitchConfigFlag {
    FRAGNORMAL(0, "FRAG_NORMAL"),
    OFPCFRAGDROP(1, "OFPC_FRAG_DROP"),
    OFPCFRAGREASM(2, "OFPC_FRAG_REASM"),
    OFPCFRAGMASK(3, "OFPC_FRAG_MASK");

    String name;
    int value;
    private static final Map<Integer, SwitchConfigFlag> VALUE_MAP;

    private SwitchConfigFlag(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public int getIntValue() {
        return this.value;
    }

    public static SwitchConfigFlag forValue(int valueArg) {
        return VALUE_MAP.get(valueArg);
    }

    static {
        ImmutableMap.Builder b = ImmutableMap.builder();
        for (SwitchConfigFlag enumItem : SwitchConfigFlag.values()) {
            b.put((Object)enumItem.value, (Object)enumItem);
        }
        VALUE_MAP = b.build();
    }
}

