/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.config.rev140630;

import com.google.common.collect.ImmutableMap;
import java.util.Map;

public enum TransportProtocol {
    TCP(0, "TCP"),
    TLS(1, "TLS"),
    UDP(2, "UDP");

    String name;
    int value;
    private static final Map<Integer, TransportProtocol> VALUE_MAP;

    private TransportProtocol(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public int getIntValue() {
        return this.value;
    }

    public static TransportProtocol forValue(int valueArg) {
        return VALUE_MAP.get(valueArg);
    }

    static {
        ImmutableMap.Builder b = ImmutableMap.builder();
        for (TransportProtocol enumItem : TransportProtocol.values()) {
            b.put((Object)enumItem.value, (Object)enumItem);
        }
        VALUE_MAP = b.build();
    }
}

