/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entries.grouping;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.MatchEntryFieldsGrouping;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.MatchEntryValueGrouping;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.MatchField;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.OxmClassBase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entries.grouping.MatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.MatchEntryValue;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class MatchEntryBuilder
implements Builder<MatchEntry> {
    private MatchEntryValue _matchEntryValue;
    private Class<? extends OxmClassBase> _oxmClass;
    private Class<? extends MatchField> _oxmMatchField;
    private Boolean _hasMask;
    Map<Class<? extends Augmentation<MatchEntry>>, Augmentation<MatchEntry>> augmentation = Collections.emptyMap();

    public MatchEntryBuilder() {
    }

    public MatchEntryBuilder(MatchEntryFieldsGrouping arg) {
        this._oxmClass = arg.getOxmClass();
        this._oxmMatchField = arg.getOxmMatchField();
        this._hasMask = arg.isHasMask();
    }

    public MatchEntryBuilder(MatchEntryValueGrouping arg) {
        this._matchEntryValue = arg.getMatchEntryValue();
    }

    public MatchEntryBuilder(MatchEntry base) {
        AugmentationHolder casted;
        this._matchEntryValue = base.getMatchEntryValue();
        this._oxmClass = base.getOxmClass();
        this._oxmMatchField = base.getOxmMatchField();
        this._hasMask = base.isHasMask();
        if (base instanceof MatchEntryImpl) {
            MatchEntryImpl impl = (MatchEntryImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<MatchEntry>>, Augmentation<MatchEntry>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<MatchEntry>>, Augmentation<MatchEntry>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof MatchEntryFieldsGrouping) {
            this._oxmClass = ((MatchEntryFieldsGrouping)arg).getOxmClass();
            this._oxmMatchField = ((MatchEntryFieldsGrouping)arg).getOxmMatchField();
            this._hasMask = ((MatchEntryFieldsGrouping)arg).isHasMask();
            isValidArg = true;
        }
        if (arg instanceof MatchEntryValueGrouping) {
            this._matchEntryValue = ((MatchEntryValueGrouping)arg).getMatchEntryValue();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.MatchEntryFieldsGrouping, org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.MatchEntryValueGrouping] \nbut was: " + arg);
        }
    }

    public MatchEntryValue getMatchEntryValue() {
        return this._matchEntryValue;
    }

    public Class<? extends OxmClassBase> getOxmClass() {
        return this._oxmClass;
    }

    public Class<? extends MatchField> getOxmMatchField() {
        return this._oxmMatchField;
    }

    public Boolean isHasMask() {
        return this._hasMask;
    }

    public <E extends Augmentation<MatchEntry>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public MatchEntryBuilder setMatchEntryValue(MatchEntryValue value) {
        this._matchEntryValue = value;
        return this;
    }

    public MatchEntryBuilder setOxmClass(Class<? extends OxmClassBase> value) {
        this._oxmClass = value;
        return this;
    }

    public MatchEntryBuilder setOxmMatchField(Class<? extends MatchField> value) {
        this._oxmMatchField = value;
        return this;
    }

    public MatchEntryBuilder setHasMask(Boolean value) {
        this._hasMask = value;
        return this;
    }

    public MatchEntryBuilder addAugmentation(Class<? extends Augmentation<MatchEntry>> augmentationType, Augmentation<MatchEntry> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<MatchEntry>>, Augmentation<MatchEntry>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public MatchEntryBuilder removeAugmentation(Class<? extends Augmentation<MatchEntry>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public MatchEntry build() {
        return new MatchEntryImpl(this);
    }

    private static final class MatchEntryImpl
    implements MatchEntry {
        private final MatchEntryValue _matchEntryValue;
        private final Class<? extends OxmClassBase> _oxmClass;
        private final Class<? extends MatchField> _oxmMatchField;
        private final Boolean _hasMask;
        private Map<Class<? extends Augmentation<MatchEntry>>, Augmentation<MatchEntry>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<MatchEntry> getImplementedInterface() {
            return MatchEntry.class;
        }

        private MatchEntryImpl(MatchEntryBuilder base) {
            this._matchEntryValue = base.getMatchEntryValue();
            this._oxmClass = base.getOxmClass();
            this._oxmMatchField = base.getOxmMatchField();
            this._hasMask = base.isHasMask();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<MatchEntry>>, Augmentation<MatchEntry>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<MatchEntry>>, Augmentation<MatchEntry>>(base.augmentation);
                }
            }
        }

        @Override
        public MatchEntryValue getMatchEntryValue() {
            return this._matchEntryValue;
        }

        @Override
        public Class<? extends OxmClassBase> getOxmClass() {
            return this._oxmClass;
        }

        @Override
        public Class<? extends MatchField> getOxmMatchField() {
            return this._oxmMatchField;
        }

        @Override
        public Boolean isHasMask() {
            return this._hasMask;
        }

        public <E extends Augmentation<MatchEntry>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._matchEntryValue);
            result = 31 * result + Objects.hashCode(this._oxmClass);
            result = 31 * result + Objects.hashCode(this._oxmMatchField);
            result = 31 * result + Objects.hashCode(this._hasMask);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!MatchEntry.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            MatchEntry other = (MatchEntry)obj;
            if (!Objects.equals(this._matchEntryValue, other.getMatchEntryValue())) {
                return false;
            }
            if (!Objects.equals(this._oxmClass, other.getOxmClass())) {
                return false;
            }
            if (!Objects.equals(this._oxmMatchField, other.getOxmMatchField())) {
                return false;
            }
            if (!Objects.equals(this._hasMask, other.isHasMask())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                MatchEntryImpl otherImpl = (MatchEntryImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<MatchEntry>>, Augmentation<MatchEntry>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("MatchEntry [");
            boolean first = true;
            if (this._matchEntryValue != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_matchEntryValue=");
                builder.append(this._matchEntryValue);
            }
            if (this._oxmClass != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_oxmClass=");
                builder.append(this._oxmClass);
            }
            if (this._oxmMatchField != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_oxmMatchField=");
                builder.append(this._oxmMatchField);
            }
            if (this._hasMask != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_hasMask=");
                builder.append(this._hasMask);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

