/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.arp.op._case;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.arp.op._case.ArpOp;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ArpOpBuilder
implements Builder<ArpOp> {
    private Integer _opCode;
    Map<Class<? extends Augmentation<ArpOp>>, Augmentation<ArpOp>> augmentation = Collections.emptyMap();

    public ArpOpBuilder() {
    }

    public ArpOpBuilder(ArpOp base) {
        AugmentationHolder casted;
        this._opCode = base.getOpCode();
        if (base instanceof ArpOpImpl) {
            ArpOpImpl impl = (ArpOpImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<ArpOp>>, Augmentation<ArpOp>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ArpOp>>, Augmentation<ArpOp>>(casted.augmentations());
        }
    }

    public Integer getOpCode() {
        return this._opCode;
    }

    public <E extends Augmentation<ArpOp>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkOpCodeRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public ArpOpBuilder setOpCode(Integer value) {
        if (value != null) {
            ArpOpBuilder.checkOpCodeRange(value);
        }
        this._opCode = value;
        return this;
    }

    public ArpOpBuilder addAugmentation(Class<? extends Augmentation<ArpOp>> augmentationType, Augmentation<ArpOp> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ArpOp>>, Augmentation<ArpOp>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public ArpOpBuilder removeAugmentation(Class<? extends Augmentation<ArpOp>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public ArpOp build() {
        return new ArpOpImpl(this);
    }

    private static final class ArpOpImpl
    implements ArpOp {
        private final Integer _opCode;
        private Map<Class<? extends Augmentation<ArpOp>>, Augmentation<ArpOp>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<ArpOp> getImplementedInterface() {
            return ArpOp.class;
        }

        private ArpOpImpl(ArpOpBuilder base) {
            this._opCode = base.getOpCode();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<ArpOp>>, Augmentation<ArpOp>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<ArpOp>>, Augmentation<ArpOp>>(base.augmentation);
                }
            }
        }

        @Override
        public Integer getOpCode() {
            return this._opCode;
        }

        public <E extends Augmentation<ArpOp>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._opCode);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!ArpOp.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            ArpOp other = (ArpOp)obj;
            if (!Objects.equals(this._opCode, other.getOpCode())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                ArpOpImpl otherImpl = (ArpOpImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<ArpOp>>, Augmentation<ArpOp>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("ArpOp [");
            boolean first = true;
            if (this._opCode != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_opCode=");
                builder.append(this._opCode);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

