/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.arp.spa._case;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Address;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.arp.spa._case.ArpSpa;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ArpSpaBuilder
implements Builder<ArpSpa> {
    private Ipv4Address _ipv4Address;
    private byte[] _mask;
    Map<Class<? extends Augmentation<ArpSpa>>, Augmentation<ArpSpa>> augmentation = Collections.emptyMap();

    public ArpSpaBuilder() {
    }

    public ArpSpaBuilder(ArpSpa base) {
        AugmentationHolder casted;
        this._ipv4Address = base.getIpv4Address();
        this._mask = base.getMask();
        if (base instanceof ArpSpaImpl) {
            ArpSpaImpl impl = (ArpSpaImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<ArpSpa>>, Augmentation<ArpSpa>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ArpSpa>>, Augmentation<ArpSpa>>(casted.augmentations());
        }
    }

    public Ipv4Address getIpv4Address() {
        return this._ipv4Address;
    }

    public byte[] getMask() {
        return this._mask == null ? null : (byte[])this._mask.clone();
    }

    public <E extends Augmentation<ArpSpa>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public ArpSpaBuilder setIpv4Address(Ipv4Address value) {
        this._ipv4Address = value;
        return this;
    }

    public ArpSpaBuilder setMask(byte[] value) {
        this._mask = value;
        return this;
    }

    public ArpSpaBuilder addAugmentation(Class<? extends Augmentation<ArpSpa>> augmentationType, Augmentation<ArpSpa> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ArpSpa>>, Augmentation<ArpSpa>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public ArpSpaBuilder removeAugmentation(Class<? extends Augmentation<ArpSpa>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public ArpSpa build() {
        return new ArpSpaImpl(this);
    }

    private static final class ArpSpaImpl
    implements ArpSpa {
        private final Ipv4Address _ipv4Address;
        private final byte[] _mask;
        private Map<Class<? extends Augmentation<ArpSpa>>, Augmentation<ArpSpa>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<ArpSpa> getImplementedInterface() {
            return ArpSpa.class;
        }

        private ArpSpaImpl(ArpSpaBuilder base) {
            this._ipv4Address = base.getIpv4Address();
            this._mask = base.getMask();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<ArpSpa>>, Augmentation<ArpSpa>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<ArpSpa>>, Augmentation<ArpSpa>>(base.augmentation);
                }
            }
        }

        @Override
        public Ipv4Address getIpv4Address() {
            return this._ipv4Address;
        }

        @Override
        public byte[] getMask() {
            return this._mask == null ? null : (byte[])this._mask.clone();
        }

        public <E extends Augmentation<ArpSpa>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._ipv4Address);
            result = 31 * result + Arrays.hashCode(this._mask);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!ArpSpa.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            ArpSpa other = (ArpSpa)obj;
            if (!Objects.equals(this._ipv4Address, other.getIpv4Address())) {
                return false;
            }
            if (!Arrays.equals(this._mask, other.getMask())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                ArpSpaImpl otherImpl = (ArpSpaImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<ArpSpa>>, Augmentation<ArpSpa>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("ArpSpa [");
            boolean first = true;
            if (this._ipv4Address != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_ipv4Address=");
                builder.append(this._ipv4Address);
            }
            if (this._mask != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_mask=");
                builder.append(Arrays.toString(this._mask));
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

