/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.eth.src._case;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.MacAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.eth.src._case.EthSrc;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class EthSrcBuilder
implements Builder<EthSrc> {
    private MacAddress _macAddress;
    private byte[] _mask;
    Map<Class<? extends Augmentation<EthSrc>>, Augmentation<EthSrc>> augmentation = Collections.emptyMap();

    public EthSrcBuilder() {
    }

    public EthSrcBuilder(EthSrc base) {
        AugmentationHolder casted;
        this._macAddress = base.getMacAddress();
        this._mask = base.getMask();
        if (base instanceof EthSrcImpl) {
            EthSrcImpl impl = (EthSrcImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<EthSrc>>, Augmentation<EthSrc>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<EthSrc>>, Augmentation<EthSrc>>(casted.augmentations());
        }
    }

    public MacAddress getMacAddress() {
        return this._macAddress;
    }

    public byte[] getMask() {
        return this._mask == null ? null : (byte[])this._mask.clone();
    }

    public <E extends Augmentation<EthSrc>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public EthSrcBuilder setMacAddress(MacAddress value) {
        this._macAddress = value;
        return this;
    }

    public EthSrcBuilder setMask(byte[] value) {
        this._mask = value;
        return this;
    }

    public EthSrcBuilder addAugmentation(Class<? extends Augmentation<EthSrc>> augmentationType, Augmentation<EthSrc> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<EthSrc>>, Augmentation<EthSrc>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public EthSrcBuilder removeAugmentation(Class<? extends Augmentation<EthSrc>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public EthSrc build() {
        return new EthSrcImpl(this);
    }

    private static final class EthSrcImpl
    implements EthSrc {
        private final MacAddress _macAddress;
        private final byte[] _mask;
        private Map<Class<? extends Augmentation<EthSrc>>, Augmentation<EthSrc>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<EthSrc> getImplementedInterface() {
            return EthSrc.class;
        }

        private EthSrcImpl(EthSrcBuilder base) {
            this._macAddress = base.getMacAddress();
            this._mask = base.getMask();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<EthSrc>>, Augmentation<EthSrc>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<EthSrc>>, Augmentation<EthSrc>>(base.augmentation);
                }
            }
        }

        @Override
        public MacAddress getMacAddress() {
            return this._macAddress;
        }

        @Override
        public byte[] getMask() {
            return this._mask == null ? null : (byte[])this._mask.clone();
        }

        public <E extends Augmentation<EthSrc>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._macAddress);
            result = 31 * result + Arrays.hashCode(this._mask);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!EthSrc.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            EthSrc other = (EthSrc)obj;
            if (!Objects.equals(this._macAddress, other.getMacAddress())) {
                return false;
            }
            if (!Arrays.equals(this._mask, other.getMask())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                EthSrcImpl otherImpl = (EthSrcImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<EthSrc>>, Augmentation<EthSrc>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("EthSrc [");
            boolean first = true;
            if (this._macAddress != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_macAddress=");
                builder.append(this._macAddress);
            }
            if (this._mask != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_mask=");
                builder.append(Arrays.toString(this._mask));
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

