/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.eth.type._case;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.EtherType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.eth.type._case.EthType;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class EthTypeBuilder
implements Builder<EthType> {
    private EtherType _ethType;
    Map<Class<? extends Augmentation<EthType>>, Augmentation<EthType>> augmentation = Collections.emptyMap();

    public EthTypeBuilder() {
    }

    public EthTypeBuilder(EthType base) {
        AugmentationHolder casted;
        this._ethType = base.getEthType();
        if (base instanceof EthTypeImpl) {
            EthTypeImpl impl = (EthTypeImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<EthType>>, Augmentation<EthType>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<EthType>>, Augmentation<EthType>>(casted.augmentations());
        }
    }

    public EtherType getEthType() {
        return this._ethType;
    }

    public <E extends Augmentation<EthType>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public EthTypeBuilder setEthType(EtherType value) {
        this._ethType = value;
        return this;
    }

    public EthTypeBuilder addAugmentation(Class<? extends Augmentation<EthType>> augmentationType, Augmentation<EthType> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<EthType>>, Augmentation<EthType>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public EthTypeBuilder removeAugmentation(Class<? extends Augmentation<EthType>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public EthType build() {
        return new EthTypeImpl(this);
    }

    private static final class EthTypeImpl
    implements EthType {
        private final EtherType _ethType;
        private Map<Class<? extends Augmentation<EthType>>, Augmentation<EthType>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<EthType> getImplementedInterface() {
            return EthType.class;
        }

        private EthTypeImpl(EthTypeBuilder base) {
            this._ethType = base.getEthType();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<EthType>>, Augmentation<EthType>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<EthType>>, Augmentation<EthType>>(base.augmentation);
                }
            }
        }

        @Override
        public EtherType getEthType() {
            return this._ethType;
        }

        public <E extends Augmentation<EthType>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._ethType);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!EthType.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            EthType other = (EthType)obj;
            if (!Objects.equals(this._ethType, other.getEthType())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                EthTypeImpl otherImpl = (EthTypeImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<EthType>>, Augmentation<EthType>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("EthType [");
            boolean first = true;
            if (this._ethType != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_ethType=");
                builder.append(this._ethType);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

