/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.icmpv4.code._case;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.icmpv4.code._case.Icmpv4Code;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class Icmpv4CodeBuilder
implements Builder<Icmpv4Code> {
    private Short _icmpv4Code;
    Map<Class<? extends Augmentation<Icmpv4Code>>, Augmentation<Icmpv4Code>> augmentation = Collections.emptyMap();

    public Icmpv4CodeBuilder() {
    }

    public Icmpv4CodeBuilder(Icmpv4Code base) {
        AugmentationHolder casted;
        this._icmpv4Code = base.getIcmpv4Code();
        if (base instanceof Icmpv4CodeImpl) {
            Icmpv4CodeImpl impl = (Icmpv4CodeImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Icmpv4Code>>, Augmentation<Icmpv4Code>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Icmpv4Code>>, Augmentation<Icmpv4Code>>(casted.augmentations());
        }
    }

    public Short getIcmpv4Code() {
        return this._icmpv4Code;
    }

    public <E extends Augmentation<Icmpv4Code>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkIcmpv4CodeRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u2025255]].", value));
    }

    public Icmpv4CodeBuilder setIcmpv4Code(Short value) {
        if (value != null) {
            Icmpv4CodeBuilder.checkIcmpv4CodeRange(value);
        }
        this._icmpv4Code = value;
        return this;
    }

    public Icmpv4CodeBuilder addAugmentation(Class<? extends Augmentation<Icmpv4Code>> augmentationType, Augmentation<Icmpv4Code> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Icmpv4Code>>, Augmentation<Icmpv4Code>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public Icmpv4CodeBuilder removeAugmentation(Class<? extends Augmentation<Icmpv4Code>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Icmpv4Code build() {
        return new Icmpv4CodeImpl(this);
    }

    private static final class Icmpv4CodeImpl
    implements Icmpv4Code {
        private final Short _icmpv4Code;
        private Map<Class<? extends Augmentation<Icmpv4Code>>, Augmentation<Icmpv4Code>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Icmpv4Code> getImplementedInterface() {
            return Icmpv4Code.class;
        }

        private Icmpv4CodeImpl(Icmpv4CodeBuilder base) {
            this._icmpv4Code = base.getIcmpv4Code();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Icmpv4Code>>, Augmentation<Icmpv4Code>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Icmpv4Code>>, Augmentation<Icmpv4Code>>(base.augmentation);
                }
            }
        }

        @Override
        public Short getIcmpv4Code() {
            return this._icmpv4Code;
        }

        public <E extends Augmentation<Icmpv4Code>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._icmpv4Code);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Icmpv4Code.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Icmpv4Code other = (Icmpv4Code)obj;
            if (!Objects.equals(this._icmpv4Code, other.getIcmpv4Code())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                Icmpv4CodeImpl otherImpl = (Icmpv4CodeImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Icmpv4Code>>, Augmentation<Icmpv4Code>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("Icmpv4Code [");
            boolean first = true;
            if (this._icmpv4Code != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_icmpv4Code=");
                builder.append(this._icmpv4Code);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

