/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.icmpv4.type._case;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.icmpv4.type._case.Icmpv4Type;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class Icmpv4TypeBuilder
implements Builder<Icmpv4Type> {
    private Short _icmpv4Type;
    Map<Class<? extends Augmentation<Icmpv4Type>>, Augmentation<Icmpv4Type>> augmentation = Collections.emptyMap();

    public Icmpv4TypeBuilder() {
    }

    public Icmpv4TypeBuilder(Icmpv4Type base) {
        AugmentationHolder casted;
        this._icmpv4Type = base.getIcmpv4Type();
        if (base instanceof Icmpv4TypeImpl) {
            Icmpv4TypeImpl impl = (Icmpv4TypeImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Icmpv4Type>>, Augmentation<Icmpv4Type>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Icmpv4Type>>, Augmentation<Icmpv4Type>>(casted.augmentations());
        }
    }

    public Short getIcmpv4Type() {
        return this._icmpv4Type;
    }

    public <E extends Augmentation<Icmpv4Type>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkIcmpv4TypeRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u2025255]].", value));
    }

    public Icmpv4TypeBuilder setIcmpv4Type(Short value) {
        if (value != null) {
            Icmpv4TypeBuilder.checkIcmpv4TypeRange(value);
        }
        this._icmpv4Type = value;
        return this;
    }

    public Icmpv4TypeBuilder addAugmentation(Class<? extends Augmentation<Icmpv4Type>> augmentationType, Augmentation<Icmpv4Type> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Icmpv4Type>>, Augmentation<Icmpv4Type>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public Icmpv4TypeBuilder removeAugmentation(Class<? extends Augmentation<Icmpv4Type>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Icmpv4Type build() {
        return new Icmpv4TypeImpl(this);
    }

    private static final class Icmpv4TypeImpl
    implements Icmpv4Type {
        private final Short _icmpv4Type;
        private Map<Class<? extends Augmentation<Icmpv4Type>>, Augmentation<Icmpv4Type>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Icmpv4Type> getImplementedInterface() {
            return Icmpv4Type.class;
        }

        private Icmpv4TypeImpl(Icmpv4TypeBuilder base) {
            this._icmpv4Type = base.getIcmpv4Type();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Icmpv4Type>>, Augmentation<Icmpv4Type>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Icmpv4Type>>, Augmentation<Icmpv4Type>>(base.augmentation);
                }
            }
        }

        @Override
        public Short getIcmpv4Type() {
            return this._icmpv4Type;
        }

        public <E extends Augmentation<Icmpv4Type>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._icmpv4Type);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Icmpv4Type.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Icmpv4Type other = (Icmpv4Type)obj;
            if (!Objects.equals(this._icmpv4Type, other.getIcmpv4Type())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                Icmpv4TypeImpl otherImpl = (Icmpv4TypeImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Icmpv4Type>>, Augmentation<Icmpv4Type>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("Icmpv4Type [");
            boolean first = true;
            if (this._icmpv4Type != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_icmpv4Type=");
                builder.append(this._icmpv4Type);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

