/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.icmpv6.code._case;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.icmpv6.code._case.Icmpv6Code;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class Icmpv6CodeBuilder
implements Builder<Icmpv6Code> {
    private Short _icmpv6Code;
    Map<Class<? extends Augmentation<Icmpv6Code>>, Augmentation<Icmpv6Code>> augmentation = Collections.emptyMap();

    public Icmpv6CodeBuilder() {
    }

    public Icmpv6CodeBuilder(Icmpv6Code base) {
        AugmentationHolder casted;
        this._icmpv6Code = base.getIcmpv6Code();
        if (base instanceof Icmpv6CodeImpl) {
            Icmpv6CodeImpl impl = (Icmpv6CodeImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Icmpv6Code>>, Augmentation<Icmpv6Code>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Icmpv6Code>>, Augmentation<Icmpv6Code>>(casted.augmentations());
        }
    }

    public Short getIcmpv6Code() {
        return this._icmpv6Code;
    }

    public <E extends Augmentation<Icmpv6Code>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkIcmpv6CodeRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u2025255]].", value));
    }

    public Icmpv6CodeBuilder setIcmpv6Code(Short value) {
        if (value != null) {
            Icmpv6CodeBuilder.checkIcmpv6CodeRange(value);
        }
        this._icmpv6Code = value;
        return this;
    }

    public Icmpv6CodeBuilder addAugmentation(Class<? extends Augmentation<Icmpv6Code>> augmentationType, Augmentation<Icmpv6Code> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Icmpv6Code>>, Augmentation<Icmpv6Code>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public Icmpv6CodeBuilder removeAugmentation(Class<? extends Augmentation<Icmpv6Code>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Icmpv6Code build() {
        return new Icmpv6CodeImpl(this);
    }

    private static final class Icmpv6CodeImpl
    implements Icmpv6Code {
        private final Short _icmpv6Code;
        private Map<Class<? extends Augmentation<Icmpv6Code>>, Augmentation<Icmpv6Code>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Icmpv6Code> getImplementedInterface() {
            return Icmpv6Code.class;
        }

        private Icmpv6CodeImpl(Icmpv6CodeBuilder base) {
            this._icmpv6Code = base.getIcmpv6Code();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Icmpv6Code>>, Augmentation<Icmpv6Code>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Icmpv6Code>>, Augmentation<Icmpv6Code>>(base.augmentation);
                }
            }
        }

        @Override
        public Short getIcmpv6Code() {
            return this._icmpv6Code;
        }

        public <E extends Augmentation<Icmpv6Code>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._icmpv6Code);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Icmpv6Code.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Icmpv6Code other = (Icmpv6Code)obj;
            if (!Objects.equals(this._icmpv6Code, other.getIcmpv6Code())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                Icmpv6CodeImpl otherImpl = (Icmpv6CodeImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Icmpv6Code>>, Augmentation<Icmpv6Code>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("Icmpv6Code [");
            boolean first = true;
            if (this._icmpv6Code != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_icmpv6Code=");
                builder.append(this._icmpv6Code);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

