/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.icmpv6.type._case;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.icmpv6.type._case.Icmpv6Type;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class Icmpv6TypeBuilder
implements Builder<Icmpv6Type> {
    private Short _icmpv6Type;
    Map<Class<? extends Augmentation<Icmpv6Type>>, Augmentation<Icmpv6Type>> augmentation = Collections.emptyMap();

    public Icmpv6TypeBuilder() {
    }

    public Icmpv6TypeBuilder(Icmpv6Type base) {
        AugmentationHolder casted;
        this._icmpv6Type = base.getIcmpv6Type();
        if (base instanceof Icmpv6TypeImpl) {
            Icmpv6TypeImpl impl = (Icmpv6TypeImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Icmpv6Type>>, Augmentation<Icmpv6Type>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Icmpv6Type>>, Augmentation<Icmpv6Type>>(casted.augmentations());
        }
    }

    public Short getIcmpv6Type() {
        return this._icmpv6Type;
    }

    public <E extends Augmentation<Icmpv6Type>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkIcmpv6TypeRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u2025255]].", value));
    }

    public Icmpv6TypeBuilder setIcmpv6Type(Short value) {
        if (value != null) {
            Icmpv6TypeBuilder.checkIcmpv6TypeRange(value);
        }
        this._icmpv6Type = value;
        return this;
    }

    public Icmpv6TypeBuilder addAugmentation(Class<? extends Augmentation<Icmpv6Type>> augmentationType, Augmentation<Icmpv6Type> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Icmpv6Type>>, Augmentation<Icmpv6Type>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public Icmpv6TypeBuilder removeAugmentation(Class<? extends Augmentation<Icmpv6Type>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Icmpv6Type build() {
        return new Icmpv6TypeImpl(this);
    }

    private static final class Icmpv6TypeImpl
    implements Icmpv6Type {
        private final Short _icmpv6Type;
        private Map<Class<? extends Augmentation<Icmpv6Type>>, Augmentation<Icmpv6Type>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Icmpv6Type> getImplementedInterface() {
            return Icmpv6Type.class;
        }

        private Icmpv6TypeImpl(Icmpv6TypeBuilder base) {
            this._icmpv6Type = base.getIcmpv6Type();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Icmpv6Type>>, Augmentation<Icmpv6Type>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Icmpv6Type>>, Augmentation<Icmpv6Type>>(base.augmentation);
                }
            }
        }

        @Override
        public Short getIcmpv6Type() {
            return this._icmpv6Type;
        }

        public <E extends Augmentation<Icmpv6Type>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._icmpv6Type);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Icmpv6Type.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Icmpv6Type other = (Icmpv6Type)obj;
            if (!Objects.equals(this._icmpv6Type, other.getIcmpv6Type())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                Icmpv6TypeImpl otherImpl = (Icmpv6TypeImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Icmpv6Type>>, Augmentation<Icmpv6Type>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("Icmpv6Type [");
            boolean first = true;
            if (this._icmpv6Type != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_icmpv6Type=");
                builder.append(this._icmpv6Type);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

