/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.ip.ecn._case;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.ip.ecn._case.IpEcn;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class IpEcnBuilder
implements Builder<IpEcn> {
    private Short _ecn;
    Map<Class<? extends Augmentation<IpEcn>>, Augmentation<IpEcn>> augmentation = Collections.emptyMap();

    public IpEcnBuilder() {
    }

    public IpEcnBuilder(IpEcn base) {
        AugmentationHolder casted;
        this._ecn = base.getEcn();
        if (base instanceof IpEcnImpl) {
            IpEcnImpl impl = (IpEcnImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<IpEcn>>, Augmentation<IpEcn>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<IpEcn>>, Augmentation<IpEcn>>(casted.augmentations());
        }
    }

    public Short getEcn() {
        return this._ecn;
    }

    public <E extends Augmentation<IpEcn>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkEcnRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u2025255]].", value));
    }

    public IpEcnBuilder setEcn(Short value) {
        if (value != null) {
            IpEcnBuilder.checkEcnRange(value);
        }
        this._ecn = value;
        return this;
    }

    public IpEcnBuilder addAugmentation(Class<? extends Augmentation<IpEcn>> augmentationType, Augmentation<IpEcn> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<IpEcn>>, Augmentation<IpEcn>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public IpEcnBuilder removeAugmentation(Class<? extends Augmentation<IpEcn>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public IpEcn build() {
        return new IpEcnImpl(this);
    }

    private static final class IpEcnImpl
    implements IpEcn {
        private final Short _ecn;
        private Map<Class<? extends Augmentation<IpEcn>>, Augmentation<IpEcn>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<IpEcn> getImplementedInterface() {
            return IpEcn.class;
        }

        private IpEcnImpl(IpEcnBuilder base) {
            this._ecn = base.getEcn();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<IpEcn>>, Augmentation<IpEcn>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<IpEcn>>, Augmentation<IpEcn>>(base.augmentation);
                }
            }
        }

        @Override
        public Short getEcn() {
            return this._ecn;
        }

        public <E extends Augmentation<IpEcn>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._ecn);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!IpEcn.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            IpEcn other = (IpEcn)obj;
            if (!Objects.equals(this._ecn, other.getEcn())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                IpEcnImpl otherImpl = (IpEcnImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<IpEcn>>, Augmentation<IpEcn>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("IpEcn [");
            boolean first = true;
            if (this._ecn != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_ecn=");
                builder.append(this._ecn);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

